/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index.factory;

import org.structr.api.search.QueryPredicate;
import org.structr.api.search.RangeQuery;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.index.factory.AbstractQueryFactory;
import org.structr.bolt.index.factory.QueryFactory;

public class RangeQueryFactory
extends AbstractQueryFactory {
    @Override
    public boolean createQuery(QueryFactory parent, QueryPredicate predicate, CypherQuery query, boolean isFirst) {
        if (predicate instanceof RangeQuery) {
            this.checkOccur(query, predicate.getOccurrence(), isFirst);
            RangeQuery rangeQuery = (RangeQuery)predicate;
            Object rangeStart = this.getReadValue(rangeQuery.getRangeStart());
            Object rangeEnd = this.getReadValue(rangeQuery.getRangeEnd());
            String name = predicate.getName();
            if (rangeStart == null && rangeEnd == null) {
                return false;
            }
            query.addParameters(name, ">=", rangeStart, "<=", rangeEnd);
            return true;
        }
        return false;
    }
}

