/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.index.factory;

import org.structr.api.search.QueryPredicate;
import org.structr.api.search.SpatialQuery;
import org.structr.bolt.index.CypherQuery;
import org.structr.bolt.index.factory.AbstractQueryFactory;
import org.structr.bolt.index.factory.QueryFactory;

public class SpatialQueryFactory
extends AbstractQueryFactory {
    @Override
    public boolean createQuery(QueryFactory parent, QueryPredicate predicate, CypherQuery query, boolean isFirst) {
        if (predicate instanceof SpatialQuery) {
            this.checkOccur(query, predicate.getOccurrence(), isFirst);
            SpatialQuery spatial = (SpatialQuery)predicate;
            StringBuilder buf = new StringBuilder();
            Double[] coords = spatial.getCoords();
            buf.append("distance(point({latitude:");
            buf.append(coords[0]);
            buf.append(",longitude:");
            buf.append(coords[1]);
            buf.append("}), point(n))");
            query.beginGroup();
            query.addSimpleParameter("latitude", "IS NOT", null);
            query.and();
            query.addSimpleParameter("longitude", "IS NOT", null);
            query.and();
            query.addSimpleParameter(buf.toString(), "<", spatial.getDistance() * 1000.0, false);
            query.endGroup();
            return true;
        }
        return false;
    }
}

