/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.wrapper.MixedResultWrapper;

public class MapResultWrapper
implements Map<String, Object> {
    protected Map<String, Object> source = null;
    protected MixedResultWrapper wrapper = null;
    protected BoltDatabaseService db = null;

    public MapResultWrapper(BoltDatabaseService db, Map<String, Object> source) {
        this.wrapper = new MixedResultWrapper(db);
        this.source = source;
        this.db = db;
    }

    @Override
    public int size() {
        return this.source.size();
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.source.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.source.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.wrap(this.source.get(key));
    }

    @Override
    public Object put(String key, Object value) {
        throw new UnsupportedOperationException("This result object is read-only");
    }

    @Override
    public Object remove(Object key) {
        throw new UnsupportedOperationException("This result object is read-only");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        throw new UnsupportedOperationException("This result object is read-only");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This result object is read-only");
    }

    @Override
    public Set<String> keySet() {
        return this.source.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.wrap(this.source.values());
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        LinkedHashSet<Map.Entry<String, Object>> wrappedSet = new LinkedHashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.source.entrySet()) {
            wrappedSet.add(new WrappedEntry(entry));
        }
        return wrappedSet;
    }

    private Object wrap(Object value) {
        if (value instanceof Map) {
            return new MapResultWrapper(this.db, (Map)value);
        }
        if (value instanceof Collection) {
            return this.wrap((Collection)value);
        }
        return this.wrapper.apply(value);
    }

    private Collection<Object> wrap(Collection<Object> source) {
        LinkedList<Object> values = new LinkedList<Object>();
        for (Object obj : source) {
            values.add(this.wrap(obj));
        }
        return values;
    }

    private class WrappedEntry
    implements Map.Entry<String, Object> {
        private Map.Entry<String, Object> source = null;

        public WrappedEntry(Map.Entry<String, Object> source) {
            this.source = source;
        }

        @Override
        public String getKey() {
            return this.source.getKey();
        }

        @Override
        public Object getValue() {
            return MapResultWrapper.this.wrap(this.source.getValue());
        }

        @Override
        public Object setValue(Object value) {
            throw new UnsupportedOperationException("This result object is read-only");
        }
    }
}

