/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.util.function.Function;
import org.neo4j.driver.v1.types.Node;
import org.neo4j.driver.v1.types.Path;
import org.neo4j.driver.v1.types.Relationship;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.wrapper.NodeWrapper;
import org.structr.bolt.wrapper.PathWrapper;
import org.structr.bolt.wrapper.RelationshipWrapper;

public class MixedResultWrapper<S, T>
implements Function<S, T> {
    protected BoltDatabaseService db = null;

    public MixedResultWrapper(BoltDatabaseService db) {
        this.db = db;
    }

    @Override
    public T apply(S from) throws RuntimeException {
        if (from instanceof Node) {
            return (T)NodeWrapper.newInstance(this.db, (Node)from);
        }
        if (from instanceof Relationship) {
            return (T)RelationshipWrapper.newInstance(this.db, (Relationship)from);
        }
        if (from instanceof Path) {
            return (T)new PathWrapper(this.db, (Path)from);
        }
        return (T)from;
    }
}

