/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.v1.types.Node;
import org.structr.api.graph.Direction;
import org.structr.api.graph.Label;
import org.structr.api.graph.Relationship;
import org.structr.api.graph.RelationshipType;
import org.structr.api.util.FixedSizeCache;
import org.structr.api.util.Iterables;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.SessionTransaction;
import org.structr.bolt.mapper.RelationshipRelationshipMapper;
import org.structr.bolt.wrapper.EntityWrapper;
import org.structr.bolt.wrapper.RelationshipWrapper;

public class NodeWrapper
extends EntityWrapper<Node>
implements org.structr.api.graph.Node {
    private final Map<String, Map<String, List<Relationship>>> relationshipCache = new HashMap<String, Map<String, List<Relationship>>>();
    private static FixedSizeCache<Long, NodeWrapper> nodeCache = null;

    private NodeWrapper(BoltDatabaseService db, Node node) {
        super(db, node);
    }

    public static void initialize(int cacheSize) {
        nodeCache = new FixedSizeCache(cacheSize);
    }

    @Override
    protected String getQueryPrefix() {
        return "MATCH (n)";
    }

    public void onRemoveFromCache() {
        this.relationshipCache.clear();
        this.stale = true;
    }

    @Override
    public void clearCaches() {
        this.relationshipCache.clear();
    }

    public Relationship createRelationshipTo(org.structr.api.graph.Node endNode, RelationshipType relationshipType) {
        return this.createRelationshipTo(endNode, relationshipType, Collections.EMPTY_MAP);
    }

    public Relationship createRelationshipTo(org.structr.api.graph.Node endNode, RelationshipType relationshipType, Map<String, Object> properties) {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        NodeWrapper otherNode = (NodeWrapper)endNode;
        map.put("id1", this.id);
        map.put("id2", endNode.getId());
        map.put("relProperties", properties);
        org.neo4j.driver.v1.types.Relationship rel = tx.getRelationship("MATCH (n), (m) WHERE ID(n) = {id1} AND ID(m) = {id2} MERGE (n)-[r:" + relationshipType.name() + "]->(m) SET r += {relProperties} RETURN r", map);
        tx.modified(this);
        tx.modified(otherNode);
        ((NodeWrapper)endNode).relationshipCache.clear();
        this.relationshipCache.clear();
        return RelationshipWrapper.newInstance(this.db, rel);
    }

    public void addLabel(Label label) {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        tx.set("MATCH (n) WHERE ID(n) = {id} SET n :" + label.name(), map);
        tx.modified(this);
    }

    public void removeLabel(Label label) {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        tx.set("MATCH (n) WHERE ID(n) = {id} REMOVE n:" + label.name(), map);
        tx.modified(this);
    }

    public Iterable<Label> getLabels() {
        this.assertNotStale();
        SessionTransaction tx = this.db.getCurrentTransaction();
        HashMap<String, Object> map = new HashMap<String, Object>();
        LinkedList<Label> result = new LinkedList<Label>();
        map.put("id", this.id);
        for (String label : tx.getStrings("MATCH (n) WHERE ID(n) = {id} RETURN LABELS(n)", map)) {
            result.add(this.db.forName(Label.class, label));
        }
        return result;
    }

    public Iterable<Relationship> getRelationships() {
        this.assertNotStale();
        RelationshipRelationshipMapper mapper = new RelationshipRelationshipMapper(this.db);
        List list = this.getList(null, null);
        if (list == null) {
            SessionTransaction tx = this.db.getCurrentTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            list = Iterables.toList((Iterable)Iterables.map((Function)mapper, tx.getRelationships("MATCH (n)-[r]-() WHERE ID(n) = {id} RETURN r", map)));
            this.setList(null, null, list);
        }
        return list;
    }

    public Iterable<Relationship> getRelationships(Direction direction) {
        this.assertNotStale();
        RelationshipRelationshipMapper mapper = new RelationshipRelationshipMapper(this.db);
        List list = this.getList(direction, null);
        if (list == null) {
            SessionTransaction tx = this.db.getCurrentTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            switch (direction) {
                case BOTH: {
                    return this.getRelationships();
                }
                case OUTGOING: {
                    list = Iterables.toList((Iterable)Iterables.map((Function)mapper, tx.getRelationships("MATCH (n)-[r]->() WHERE ID(n) = {id} RETURN r", map)));
                    break;
                }
                case INCOMING: {
                    list = Iterables.toList((Iterable)Iterables.map((Function)mapper, tx.getRelationships("MATCH (n)<-[r]-() WHERE ID(n) = {id} RETURN r", map)));
                }
            }
            this.setList(direction, null, list);
        }
        return list;
    }

    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType relationshipType) {
        this.assertNotStale();
        RelationshipRelationshipMapper mapper = new RelationshipRelationshipMapper(this.db);
        List list = this.getList(direction, relationshipType);
        if (list == null) {
            SessionTransaction tx = this.db.getCurrentTransaction();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            switch (direction) {
                case BOTH: {
                    list = Iterables.toList((Iterable)Iterables.map((Function)mapper, tx.getRelationships("MATCH (n)-[r:" + relationshipType.name() + "]-() WHERE ID(n) = {id} RETURN r", map)));
                    break;
                }
                case OUTGOING: {
                    list = Iterables.toList((Iterable)Iterables.map((Function)mapper, tx.getRelationships("MATCH (n)-[r:" + relationshipType.name() + "]->() WHERE ID(n) = {id} RETURN r", map)));
                    break;
                }
                case INCOMING: {
                    list = Iterables.toList((Iterable)Iterables.map((Function)mapper, tx.getRelationships("MATCH (n)<-[r:" + relationshipType.name() + "]-() WHERE ID(n) = {id} RETURN r", map)));
                }
            }
            this.setList(direction, relationshipType, list);
        }
        return list;
    }

    @Override
    public void delete() {
        super.delete();
        nodeCache.remove((Object)this.id);
    }

    public static void clearCache() {
        nodeCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeWrapper newInstance(BoltDatabaseService db, Node node) {
        FixedSizeCache<Long, NodeWrapper> fixedSizeCache = nodeCache;
        synchronized (fixedSizeCache) {
            NodeWrapper wrapper = (NodeWrapper)nodeCache.get((Object)node.id());
            if (wrapper == null) {
                wrapper = new NodeWrapper(db, node);
                nodeCache.put((Object)node.id(), (Object)wrapper);
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeWrapper newInstance(BoltDatabaseService db, long id) {
        FixedSizeCache<Long, NodeWrapper> fixedSizeCache = nodeCache;
        synchronized (fixedSizeCache) {
            NodeWrapper wrapper = (NodeWrapper)nodeCache.get((Object)id);
            if (wrapper == null) {
                SessionTransaction tx = db.getCurrentTransaction();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", id);
                wrapper = new NodeWrapper(db, tx.getNode("MATCH (n) WHERE ID(n) = {id} RETURN n", map));
                nodeCache.put((Object)id, (Object)wrapper);
            }
            return wrapper;
        }
    }

    private Map<String, List<Relationship>> getCache(Direction direction) {
        String key = direction != null ? direction.name() : "*";
        Map<String, List<Relationship>> cache = this.relationshipCache.get(key);
        if (cache == null) {
            cache = new HashMap<String, List<Relationship>>();
            this.relationshipCache.put(key, cache);
        }
        return cache;
    }

    private List<Relationship> getList(Direction direction, RelationshipType relType) {
        String key = relType != null ? relType.name() : "*";
        Map<String, List<Relationship>> cache = this.getCache(direction);
        return cache.get(key);
    }

    private void setList(Direction direction, RelationshipType relType, List<Relationship> list) {
        String key = relType != null ? relType.name() : "*";
        Map<String, List<Relationship>> cache = this.getCache(direction);
        cache.put(key, list);
    }
}

