/*
 * Decompiled with CFR 0.152.
 */
package org.structr.bolt.wrapper;

import java.util.Iterator;
import org.neo4j.driver.v1.types.Path;
import org.structr.api.NotFoundException;
import org.structr.api.graph.PropertyContainer;
import org.structr.bolt.BoltDatabaseService;
import org.structr.bolt.wrapper.NodeWrapper;
import org.structr.bolt.wrapper.RelationshipWrapper;

public class PathWrapper
implements org.structr.api.graph.Path {
    private Path path = null;
    private BoltDatabaseService db = null;

    public PathWrapper(BoltDatabaseService db, Path path) {
        this.path = path;
        this.db = db;
    }

    public Iterator<PropertyContainer> iterator() {
        final Iterator it = this.path.iterator();
        return new Iterator<PropertyContainer>(){
            private Path.Segment current = null;
            private int state = 0;

            @Override
            public boolean hasNext() {
                return it.hasNext() || this.state < 2;
            }

            @Override
            public PropertyContainer next() {
                if (this.current == null) {
                    this.current = (Path.Segment)it.next();
                } else if (this.state == 2) {
                    this.current = (Path.Segment)it.next();
                    this.state = 1;
                }
                switch (this.state) {
                    case 0: {
                        this.state = 1;
                        return NodeWrapper.newInstance(PathWrapper.this.db, this.current.start());
                    }
                    case 1: {
                        this.state = 2;
                        return RelationshipWrapper.newInstance(PathWrapper.this.db, this.current.relationship());
                    }
                    case 2: {
                        this.state = 0;
                        return NodeWrapper.newInstance(PathWrapper.this.db, this.current.end());
                    }
                }
                throw new NotFoundException("No such element.");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal not supported.");
            }
        };
    }
}

