/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.AssertionType;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.ldap.api.LDAPAttribute;
import org.structr.ldap.api.LDAPNode;
import org.structr.ldap.api.LDAPValue;
import org.structr.ldap.entity.LDAPNodeImpl;

public class StructrLDAPWrapper {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrLDAPWrapper.class.getName());
    private SecurityContext securityContext = null;
    private SchemaManager schemaManager = null;
    private String partitionId = null;
    private Class<? extends LDAPNode> type = null;

    public StructrLDAPWrapper(SecurityContext securityContext, SchemaManager schemaManager, String string, Class<? extends LDAPNode> clazz) {
        this.securityContext = securityContext;
        this.schemaManager = schemaManager;
        this.partitionId = string;
        this.type = clazz;
    }

    public void add(Entry entry) throws LdapException {
        try (Tx tx = this.app().tx();){
            Dn dn = entry.getDn();
            LDAPNode lDAPNode = this.find(dn.getParent());
            if (lDAPNode != null) {
                Attribute attribute = entry.get(this.schemaManager.getAttributeType("2.5.4.0"));
                ObjectClassRegistry objectClassRegistry = this.schemaManager.getObjectClassRegistry();
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                Rdn rdn = dn.getRdn();
                String string = null;
                if (!rdn.isSchemaAware()) {
                    rdn.apply(this.schemaManager);
                }
                if (attribute != null) {
                    String string2;
                    for (Object object : attribute) {
                        String string3 = object.getString();
                        string2 = objectClassRegistry.getOidByName(string3);
                        if (((ObjectClass)objectClassRegistry.get(string2)).isStructural()) {
                            string = string3;
                            continue;
                        }
                        linkedHashSet.add(string3);
                    }
                    LDAPNode lDAPNode2 = lDAPNode.createChild(rdn.getNormName(), rdn.getName(), string, linkedHashSet);
                    if (lDAPNode2 != null) {
                        for (String string3 : entry) {
                            string2 = string3.getAttributeType();
                            String string4 = null;
                            if (string2 != null) {
                                string4 = string2.getOid();
                            } else {
                                string2 = this.schemaManager.getAttributeType(string3.getUpId());
                                string4 = string2.getOid();
                            }
                            lDAPNode2.createAttribute(string4, string3.getUpId(), (Iterable<Value<?>>)((Object)string3));
                        }
                    } else {
                        logger.warn("Unable to add entry {}, could not create new instance", (Object)entry);
                    }
                } else {
                    logger.warn("Unable to add entry {}, could not determine object class(es)", (Object)entry);
                }
            } else {
                logger.warn("Unable to add entry {}, parent not found", (Object)entry);
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            this.handleException(frameworkException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entry get(Dn dn) throws LdapException {
        try (Tx tx = this.app().tx();){
            LDAPNode lDAPNode = this.find(dn);
            tx.success();
            if (lDAPNode == null) return null;
            Entry entry = this.getEntry(lDAPNode);
            return entry;
        }
        catch (FrameworkException frameworkException) {
            this.handleException(frameworkException);
        }
        return null;
    }

    public void delete(Dn dn) throws LdapException {
        App app = this.app();
        try (Tx tx = app.tx();){
            LDAPNode lDAPNode = this.find(dn);
            if (lDAPNode != null) {
                lDAPNode.delete();
            }
            tx.success();
        }
        catch (FrameworkException frameworkException) {
            this.handleException(frameworkException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Entry> filter(Dn dn, ExprNode exprNode, SearchScope searchScope) throws LdapException {
        try (Tx tx = this.app().tx();){
            LDAPNode lDAPNode = this.find(dn);
            List<Entry> list2 = null;
            if (lDAPNode != null) {
                list2 = this.filter(lDAPNode, exprNode, searchScope, 0);
            }
            tx.success();
            if (list2 == null) return Collections.emptyList();
            List<Entry> list = list2;
            return list;
        }
        catch (FrameworkException frameworkException) {
            this.handleException(frameworkException);
        }
        return Collections.emptyList();
    }

    public Rdn getRdn(LDAPNode lDAPNode) throws FrameworkException, LdapInvalidDnException {
        String string = lDAPNode.getUserProvidedName();
        if (string == null) {
            string = lDAPNode.getRdn();
        }
        return new Rdn(this.schemaManager, string);
    }

    public Dn getDn(LDAPNode lDAPNode) throws FrameworkException, LdapInvalidDnException {
        LDAPNode lDAPNode2 = lDAPNode.getParent();
        if (lDAPNode2 != null) {
            return new Dn(this.getRdn(lDAPNode), this.getDn(lDAPNode2));
        }
        return Dn.EMPTY_DN;
    }

    public Entry getEntry(LDAPNode lDAPNode) throws FrameworkException, LdapException {
        DefaultEntry defaultEntry = new DefaultEntry(this.schemaManager, this.getDn(lDAPNode));
        for (LDAPAttribute lDAPAttribute : lDAPNode.getAttributes()) {
            defaultEntry.add(new Attribute[]{this.getAttribute(lDAPAttribute)});
        }
        return new ClonedServerEntry((Entry)defaultEntry);
    }

    public Attribute getAttribute(LDAPAttribute lDAPAttribute) throws LdapInvalidAttributeValueException {
        AttributeType attributeType = this.schemaManager.getAttributeType(lDAPAttribute.getOid());
        DefaultAttribute defaultAttribute = new DefaultAttribute(attributeType);
        String string = lDAPAttribute.getUserProvidedId();
        if (string != null) {
            defaultAttribute.setUpId(string);
        }
        for (LDAPValue lDAPValue : lDAPAttribute.getValues()) {
            defaultAttribute.add(new String[]{lDAPValue.getStringValue()});
        }
        return defaultAttribute;
    }

    private LDAPNode find(Dn dn) throws FrameworkException, LdapException, LdapInvalidDnException {
        LinkedList linkedList = new LinkedList(dn.getRdns());
        Collections.reverse(linkedList);
        LDAPNode lDAPNode = this.getRoot();
        for (Rdn rdn : linkedList) {
            if (!rdn.isSchemaAware()) {
                rdn.apply(this.schemaManager);
            }
            if ((lDAPNode = lDAPNode.getChild(rdn.getNormName())) != null) continue;
            return null;
        }
        return lDAPNode;
    }

    private List<Entry> filter(LDAPNode lDAPNode, ExprNode exprNode, SearchScope searchScope, int n) throws FrameworkException, LdapException {
        boolean bl = SearchScope.OBJECT.equals((Object)searchScope);
        boolean bl2 = SearchScope.ONELEVEL.equals((Object)searchScope);
        boolean bl3 = SearchScope.SUBTREE.equals((Object)searchScope);
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        if ((bl || n != 0 || !bl2) && this.matches(lDAPNode, exprNode)) {
            linkedList.add(this.getEntry(lDAPNode));
        }
        if (!bl && (bl3 || n == 0 && bl2)) {
            for (LDAPNode lDAPNode2 : lDAPNode.getChildren()) {
                linkedList.addAll(this.filter(lDAPNode2, exprNode, searchScope, n + 1));
            }
        }
        return linkedList;
    }

    private boolean matches(LDAPNode lDAPNode, ExprNode exprNode) throws FrameworkException, LdapInvalidAttributeValueException {
        if (exprNode instanceof SimpleNode) {
            return this.evaluateSimpleNode(lDAPNode, (SimpleNode)exprNode);
        }
        if (exprNode instanceof SubstringNode) {
            return this.evaluateSubstringNode(lDAPNode, (SubstringNode)exprNode);
        }
        if (exprNode instanceof PresenceNode) {
            PresenceNode presenceNode = (PresenceNode)exprNode;
            DefaultAttribute defaultAttribute = new DefaultAttribute(presenceNode.getAttributeType());
            return this.findAttribute(lDAPNode, defaultAttribute.getId()) != null;
        }
        if (exprNode instanceof OrNode) {
            OrNode orNode = (OrNode)exprNode;
            for (ExprNode exprNode2 : orNode.getChildren()) {
                if (!this.matches(lDAPNode, exprNode2)) continue;
                return true;
            }
            return false;
        }
        if (exprNode instanceof AndNode) {
            AndNode andNode = (AndNode)exprNode;
            boolean bl = true;
            for (ExprNode exprNode3 : andNode.getChildren()) {
                bl &= this.matches(lDAPNode, exprNode3);
            }
            return bl;
        }
        System.out.println("Unsupported filter type " + exprNode.getClass());
        return false;
    }

    private boolean evaluateSimpleNode(LDAPNode lDAPNode, SimpleNode simpleNode) throws FrameworkException, LdapInvalidAttributeValueException {
        AssertionType assertionType = simpleNode.getAssertionType();
        DefaultAttribute defaultAttribute = new DefaultAttribute(simpleNode.getAttributeType(), new Value[]{simpleNode.getValue()});
        if (defaultAttribute != null) {
            switch (assertionType) {
                case EQUALITY: {
                    return this.hasAttributeValue(lDAPNode, (Attribute)defaultAttribute);
                }
            }
        }
        return false;
    }

    private boolean evaluateSubstringNode(LDAPNode lDAPNode, SubstringNode substringNode) throws FrameworkException, LdapInvalidAttributeValueException {
        DefaultAttribute defaultAttribute = new DefaultAttribute(substringNode.getAttributeType());
        String string = defaultAttribute.getId();
        String string2 = substringNode.getInitial();
        String string3 = substringNode.getFinal();
        LinkedList linkedList = new LinkedList();
        List list = substringNode.getAny();
        if (list != null) {
            linkedList.addAll(list);
        }
        Pattern pattern = SubstringNode.getRegex((String)string2, (String[])linkedList.toArray(new String[0]), (String)string3);
        for (LDAPAttribute lDAPAttribute : lDAPNode.getAttributes()) {
            if (!string.equals(lDAPAttribute.getOid())) continue;
            for (LDAPValue lDAPValue : lDAPAttribute.getValues()) {
                String string4 = lDAPValue.getStringValue().toLowerCase();
                Matcher matcher = pattern.matcher(string4);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAttributeValue(LDAPNode lDAPNode, Attribute attribute) throws FrameworkException, LdapInvalidAttributeValueException {
        Attribute attribute2 = this.findAttribute(lDAPNode, attribute.getId());
        if (attribute2 != null) {
            return attribute2.contains(new Value[]{attribute.get()});
        }
        return false;
    }

    private Attribute findAttribute(LDAPNode lDAPNode, String string) throws FrameworkException, LdapInvalidAttributeValueException {
        for (LDAPAttribute lDAPAttribute : lDAPNode.getAttributes()) {
            if (!string.equals(lDAPAttribute.getOid())) continue;
            return this.getAttribute(lDAPAttribute);
        }
        return null;
    }

    private LDAPNode getRoot() throws FrameworkException {
        App app = this.app();
        LDAPNode lDAPNode = (LDAPNode)app.nodeQuery(this.type).andName(this.partitionId).getFirst();
        if (lDAPNode == null) {
            lDAPNode = (LDAPNode)app.create(LDAPNodeImpl.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)this.partitionId), new NodeAttribute(LDAPNodeImpl.isRoot, (Object)true)});
        }
        return lDAPNode;
    }

    private App app() {
        return StructrApp.getInstance((SecurityContext)this.securityContext);
    }

    private void handleException(FrameworkException frameworkException) throws LdapException {
        logger.warn("", (Throwable)frameworkException);
    }
}

