/*
 * Decompiled with CFR 0.152.
 */
package org.structr.ldap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.ListCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.CacheService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursorImpl;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.interceptor.context.UnbindOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.api.partition.Subordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.SecurityContext;
import org.structr.ldap.StructrLDAPWrapper;
import org.structr.ldap.api.LDAPNode;
import org.structr.ldap.entity.LDAPNodeImpl;

class StructrPartition
implements Partition {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrPartition.class.getName());
    private Class<? extends LDAPNode> rootType = null;
    private SchemaManager schemaManager = null;
    private boolean initialized = false;
    private String id = null;
    private Dn suffixDn = null;

    public StructrPartition(SchemaManager schemaManager, String string, Dn dn) {
        this.id = string;
        this.suffixDn = dn;
        this.schemaManager = schemaManager;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public SchemaManager getSchemaManager() {
        return this.schemaManager;
    }

    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }

    public void initialize() throws LdapException {
        this.initialized = true;
    }

    public Dn getSuffixDn() {
        return this.suffixDn;
    }

    public void setSuffixDn(Dn dn) throws LdapInvalidDnException {
        this.suffixDn = dn;
    }

    public void destroy() throws Exception {
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void sync() throws Exception {
    }

    public Entry delete(DeleteOperationContext deleteOperationContext) throws LdapException {
        LdapPrincipal ldapPrincipal = deleteOperationContext.getEffectivePrincipal();
        Dn dn = deleteOperationContext.getDn();
        Entry entry = deleteOperationContext.getEntry();
        this.getWrapper(ldapPrincipal).delete(dn);
        return entry;
    }

    public void add(AddOperationContext addOperationContext) throws LdapException {
        LdapPrincipal ldapPrincipal = addOperationContext.getEffectivePrincipal();
        Entry entry = addOperationContext.getEntry();
        this.getWrapper(ldapPrincipal).add(entry);
    }

    public void modify(ModifyOperationContext modifyOperationContext) throws LdapException {
    }

    public EntryFilteringCursor search(SearchOperationContext searchOperationContext) throws LdapException {
        logger.info("{}", (Object)searchOperationContext);
        LdapPrincipal ldapPrincipal = searchOperationContext.getEffectivePrincipal();
        Dn dn = searchOperationContext.getDn();
        ExprNode exprNode = searchOperationContext.getFilter();
        SearchScope searchScope = searchOperationContext.getScope();
        List<Entry> list = this.getWrapper(ldapPrincipal).filter(dn, exprNode, searchScope);
        ListCursor listCursor = new ListCursor(list);
        SchemaManager schemaManager = this.getSchemaManager();
        return new EntryFilteringCursorImpl((Cursor)listCursor, searchOperationContext, schemaManager);
    }

    public Entry lookup(LookupOperationContext lookupOperationContext) throws LdapException {
        Dn dn = lookupOperationContext.getDn();
        if (lookupOperationContext.getSession() != null) {
            return this.getWrapper(lookupOperationContext.getEffectivePrincipal()).get(dn);
        }
        return this.getWrapper(null).get(dn);
    }

    public boolean hasEntry(HasEntryOperationContext hasEntryOperationContext) throws LdapException {
        LdapPrincipal ldapPrincipal = hasEntryOperationContext.getEffectivePrincipal();
        Dn dn = hasEntryOperationContext.getDn();
        return this.getWrapper(ldapPrincipal).get(dn) != null;
    }

    public void rename(RenameOperationContext renameOperationContext) throws LdapException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void move(MoveOperationContext moveOperationContext) throws LdapException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameOperationContext) throws LdapException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unbind(UnbindOperationContext unbindOperationContext) throws LdapException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dumpIndex(OutputStream outputStream, String string) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void repair() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCacheService(CacheService cacheService) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getContextCsn() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void saveContextCsn() throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Subordinates getSubordinates(Entry entry) throws LdapException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private StructrLDAPWrapper getWrapper(LdapPrincipal ldapPrincipal) {
        SecurityContext securityContext = SecurityContext.getSuperUserInstance();
        return new StructrLDAPWrapper(securityContext, this.schemaManager, this.id, this.getPartitionRootType());
    }

    private Class<? extends LDAPNode> getPartitionRootType() {
        if (this.rootType == null) {
            StringBuilder stringBuilder = new StringBuilder("ldap.partition.");
            stringBuilder.append(this.id);
            stringBuilder.append(".rootType");
            String string = (String)Settings.getOrCreateStringSetting((String[])new String[]{stringBuilder.toString()}).getValue();
            if (string == null) {
                logger.info("No LDAP root node type specified for partition {}, using default (LDAPNodeImpl). This default can be changed by setting a value for {} in structr.conf", new Object[]{this.id, stringBuilder.toString()});
                this.rootType = LDAPNodeImpl.class;
            } else {
                try {
                    this.rootType = Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.warn("Unable to instantiate LDAP root node class {}, falling back to default. {}", new Object[]{string, classNotFoundException.getMessage()});
                }
                if (this.rootType == null) {
                    this.rootType = LDAPNodeImpl.class;
                }
            }
        }
        return this.rootType;
    }
}

