/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.base;

import com.github.fommil.netlib.LAPACK;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math.complex.Complex;
import org.netlib.util.doubleW;
import org.netlib.util.intW;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.ComplexGroup;
import org.renjin.primitives.Types;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexArrayVector;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Lapack {
    public static final BytePtr UPPER_TRIANGLE = BytePtr.asciiString((String)"U");

    @Internal
    public static DoubleVector La_chol2inv(DoubleVector a, int sz) {
        if (IntVector.isNA(sz) || sz < 1) {
            throw new EvalException("'size' argument must be a positive integer", new Object[0]);
        }
        int m = 1;
        int n = 1;
        if (sz == 1 && !Types.isMatrix(a)) {
            return a;
        }
        if (!Types.isMatrix(a)) {
            throw new EvalException("'a' must be a numeric matrix", new Object[0]);
        }
        Vector adims = a.getAttributes().getDim();
        m = adims.getElementAsInt(0);
        n = adims.getElementAsInt(1);
        if (sz > n) {
            throw new EvalException("'size' cannot exceed ncol(x) = %d", n);
        }
        if (sz > m) {
            throw new EvalException("'size' cannot exceed nrow(x) = %d", m);
        }
        double[] result = new double[sz * sz];
        for (int j = 0; j < sz; ++j) {
            for (int i = 0; i <= j; ++i) {
                result[i + j * sz] = a.getElementAsDouble(i + j * m);
            }
        }
        intW resultCode = new intW(0);
        LAPACK.getInstance().dpotri("Upper", sz, result, sz, resultCode);
        if (resultCode.val != 0) {
            if (resultCode.val > 0) {
                throw new EvalException("element (%d, %d) is zero, so the inverse cannot be computed", resultCode.val, resultCode.val);
            }
            throw new EvalException("argument %d of Lapack routine %s had invalid value", -resultCode.val, "dpotri");
        }
        for (int j = 0; j < sz; ++j) {
            for (int i = j + 1; i < sz; ++i) {
                result[i + j * sz] = result[j + i * sz];
            }
        }
        return DoubleArrayVector.unsafe(result, AttributeMap.builder().setDim(sz, sz));
    }

    public static ListVector svd(String jobu, String jobv, DoubleVector x, DoubleVector sexp, DoubleVector uexp, DoubleVector vexp, String method) {
        Vector xdims = x.getAttributes().getDim();
        int n = xdims.getElementAsInt(0);
        int p = xdims.getElementAsInt(1);
        double[] xvals = x.toDoubleArray();
        int ldu = uexp.getAttributes().getDim().getElementAsInt(0);
        int ldvt = vexp.getAttributes().getDim().getElementAsInt(0);
        double[] s = sexp.toDoubleArray();
        double[] u = uexp.toDoubleArray();
        double[] v = vexp.toDoubleArray();
        double[] tmp = new double[1];
        int[] iwork = new int[8 * (n < p ? n : p)];
        LAPACK lapack = LAPACK.getInstance();
        int lwork = -1;
        intW info2 = new intW(0);
        lapack.dgesdd(jobu, n, p, xvals, n, s, u, ldu, v, ldvt, tmp, lwork, iwork, info2);
        if (info2.val != 0) {
            throw new EvalException("error code %d from Lapack routine '%s'", info2.val, "dgesdd");
        }
        lwork = (int)tmp[0];
        double[] work = new double[lwork];
        lapack.dgesdd(jobu, n, p, xvals, n, s, u, ldu, v, ldvt, work, lwork, iwork, info2);
        return ListVector.newNamedBuilder().add("d", (SEXP)DoubleArrayVector.unsafe(s, sexp.getAttributes())).add("u", (SEXP)DoubleArrayVector.unsafe(u, uexp.getAttributes())).add("vt", (SEXP)DoubleArrayVector.unsafe(v, vexp.getAttributes())).build();
    }

    public static SEXP dgesv(DoubleVector A, DoubleVector B, double tolerance) {
        doubleW rcond = new doubleW(0.0);
        if (!Types.isMatrix(A)) {
            throw new EvalException("'a' must be a numeric matrix", new Object[0]);
        }
        if (!Types.isMatrix(B)) {
            throw new EvalException("'b' must be a numeric matrix", new Object[0]);
        }
        Vector Adims = A.getAttributes().getDim();
        Vector Bdims = B.getAttributes().getDim();
        int n = Adims.getElementAsInt(0);
        if (n == 0) {
            throw new EvalException("'a' is 0-diml", new Object[0]);
        }
        int p = Bdims.getElementAsInt(1);
        if (p == 0) {
            throw new EvalException("no right-hand side in 'b'", new Object[0]);
        }
        if (Adims.getElementAsInt(1) != n) {
            throw new EvalException("'a' (" + n + " x " + Adims.getElementAsInt(1) + ") must be square", new Object[0]);
        }
        if (Bdims.getElementAsInt(0) != n) {
            throw new EvalException("'b' (" + Bdims.getElementAsInt(0) + " x " + p + ") must be compatible with 'a' (" + n + " x " + n + ")", new Object[0]);
        }
        int[] ipiv = new int[n];
        double[] avals = A.toDoubleArray();
        LAPACK lapack = LAPACK.getInstance();
        intW info2 = new intW(0);
        double[] result = B.toDoubleArray();
        lapack.dgesv(n, p, avals, n, ipiv, result, n, info2);
        if (info2.val < 0) {
            throw new EvalException("argument -" + info2.val + " of Lapack routine 'dgsv' had invalid value", new Object[0]);
        }
        if (info2.val > 0) {
            throw new EvalException("Lapack routine dgesv: system is exactly singular", new Object[0]);
        }
        double anorm = lapack.dlange("1", n, n, A.toDoubleArray(), n, null);
        double[] arrWork = new double[4 * n];
        lapack.dgecon("1", n, avals, n, anorm, rcond, arrWork, ipiv, info2);
        if (rcond.val < tolerance) {
            throw new EvalException("system is computationally singular: reciprocal condition number = " + rcond.val, new Object[0]);
        }
        return DoubleArrayVector.unsafe(result, B.getAttributes());
    }

    public static SEXP rs(DoubleVector x, boolean ov) {
        double vl = 0.0;
        double vu = 0.0;
        double abstol = 0.0;
        int il = 0;
        int iu = 0;
        String uplo = "L";
        int n = Lapack.getSquareMatrixSize(x);
        double[] rx = x.toDoubleArray();
        double[] rvalues = new double[n];
        String range2 = "A";
        double[] rz = null;
        if (!ov) {
            rz = new double[n * n];
        }
        String jobv = ov ? "N" : "V";
        int[] isuppz = new int[2 * n];
        int lwork = -1;
        int liwork = -1;
        intW m = new intW(0);
        int[] itmp = new int[1];
        double[] tmp = new double[1];
        LAPACK lapack = LAPACK.getInstance();
        intW info2 = new intW(0);
        lapack.dsyevr(jobv, range2, uplo, n, rx, n, vl, vu, il, iu, abstol, m, rvalues, rz, n, isuppz, tmp, lwork, itmp, liwork, info2);
        if (info2.val != 0) {
            throw new EvalException("error code %d from Lapack routine '%s'", info2, "dsyevr");
        }
        lwork = (int)tmp[0];
        liwork = itmp[0];
        double[] work = new double[lwork];
        int[] iwork = new int[liwork];
        lapack.dsyevr(jobv, range2, uplo, n, rx, n, vl, vu, il, iu, abstol, m, rvalues, rz, n, isuppz, work, lwork, iwork, liwork, info2);
        if (info2.val != 0) {
            throw new EvalException("error code %d from Lapack routine '%s'", info2, "dsyevr");
        }
        ListVector.NamedBuilder ret = ListVector.newNamedBuilder();
        ret.add("values", (SEXP)new DoubleArrayVector(rvalues));
        if (!ov) {
            ret.add("vectors", (SEXP)DoubleArrayVector.newMatrix(rz, n, n));
        }
        return ret.build();
    }

    @Internal
    public static SEXP La_chol(@Current Context context, SEXP a, int pivot, double tol) {
        int n;
        if (!Types.isMatrix(a)) {
            throw new EvalException("'a' must be a numeric matrix", new Object[0]);
        }
        double[] matrix2 = ((AtomicVector)a).toDoubleArray();
        int[] dim2 = a.getAttributes().getDimArray();
        int m = dim2[0];
        if (m != (n = dim2[1])) {
            throw new EvalException("'a' must be a square matrix", new Object[0]);
        }
        if (m <= 0) {
            throw new EvalException("'a' must have dims > 0", new Object[0]);
        }
        int N = dim2[0];
        for (int j = 0; j < n; ++j) {
            for (int i = j + 1; i < n; ++i) {
                matrix2[i + N * j] = 0.0;
            }
        }
        if (pivot != 0 && pivot != 1) {
            throw new EvalException("invalid 'pivot' value", new Object[0]);
        }
        if (pivot == 0) {
            intW info2 = new intW(0);
            LAPACK.getInstance().dpotrf("Upper", m, matrix2, m, info2);
            if (info2.val != 0) {
                if (info2.val > 0) {
                    throw new EvalException("the leading minor of order %d is not positive definite", info2);
                }
                throw new EvalException("argument %d of Lapack routine %s had invalid value", info2, "dpotrf");
            }
            return DoubleArrayVector.unsafe(matrix2, a.getAttributes());
        }
        int[] pivoti = new int[m];
        double[] work = new double[m * 2];
        IntPtr rank2 = new IntPtr(new int[]{0});
        IntPtr info3 = new IntPtr(new int[]{0});
        org.renjin.math.Lapack.dpstrf_((BytePtr)UPPER_TRIANGLE, (IntPtr)new IntPtr(new int[]{m}), (DoublePtr)new DoublePtr(matrix2), (IntPtr)new IntPtr(new int[]{m}), (IntPtr)new IntPtr(pivoti), (IntPtr)rank2, (DoublePtr)new DoublePtr(new double[]{tol}), (DoublePtr)new DoublePtr(work), (IntPtr)info3, (int)1);
        if (info3.get() != 0) {
            if (info3.get() > 0) {
                context.warn("the matrix is either rank-deficient or indefinite");
            } else {
                throw new EvalException("argument %d of Lapack routine %s had invalid value", -info3.get(), "dpstrf");
            }
        }
        return DoubleArrayVector.unsafe(matrix2, a.getAttributes().copy().set("pivot", (SEXP)IntArrayVector.unsafe(pivoti)).set("rank", (SEXP)IntArrayVector.unsafe(rank2.array)).setDimNames(Lapack.pivotColumnNames(a.getAttributes().getDimNames(), pivoti)).build());
    }

    private static Vector pivotColumnNames(Vector dimNames, int[] pivoti) {
        if (dimNames == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        Vector colNames = (Vector)dimNames.getElementAsSEXP(1);
        if (colNames == Null.INSTANCE) {
            return dimNames;
        }
        ListVector dimNamesList = (ListVector)dimNames;
        StringVector.Builder pivotedCallNames = new StringVector.Builder(colNames.length());
        for (int i = 0; i < pivoti.length; ++i) {
            pivotedCallNames.set(i, colNames.getElementAsString(pivoti[i] - 1));
        }
        return dimNamesList.newCopyBuilder().set(1, pivotedCallNames.build()).build();
    }

    public static SEXP rg(SEXP x, boolean ov) {
        int n = Lapack.getSquareMatrixSize(x);
        double[] xvals = ((DoubleVector)x).toDoubleArray();
        boolean vectors = !ov;
        String jobVR = "N";
        String jobVL = "N";
        double[] left = null;
        double[] right = null;
        if (vectors) {
            jobVR = "V";
            jobVL = "V";
            right = new double[n * n];
            left = new double[n * n];
        }
        double[] wR = new double[n];
        double[] wI = new double[n];
        int lwork = -1;
        LAPACK lapack = LAPACK.getInstance();
        double[] tmp = new double[1];
        intW info2 = new intW(0);
        lapack.dgeev(jobVL, jobVR, n, xvals, n, wR, wI, left, n, right, n, tmp, lwork, info2);
        if (info2.val != 0) {
            throw new EvalException("error code %d from Lapack routine '%s'", info2, "dgeev");
        }
        lwork = (int)tmp[0];
        double[] work = new double[lwork];
        lapack.dgeev(jobVL, jobVR, n, xvals, n, wR, wI, left, n, right, n, work, lwork, info2);
        if (info2.val != 0) {
            throw new EvalException("error code %d from Lapack routine '%s'", info2, "dgeev");
        }
        ListVector.NamedBuilder ret = new ListVector.NamedBuilder();
        if (Lapack.thereAreComplexResults(n, wR, wI)) {
            ArrayList<ComplexEntry> complex2 = new ArrayList<ComplexEntry>();
            for (int i = 0; i < n; ++i) {
                complex2.add(new ComplexEntry(Lapack.complex(wR[i], wI[i]), Arrays.copyOfRange(right, n * i, n * (i + 1))));
            }
            Collections.sort(complex2);
            Complex[] eigenvalues = ComplexEntry.getEigenvalues(n, complex2);
            ComplexArrayVector values = new ComplexArrayVector(eigenvalues);
            ret.add("values", (SEXP)values);
            ret.add("vectors", (SEXP)(vectors ? ComplexArrayVector.newMatrix(ComplexEntry.getEigenvectors(complex2), n, n) : Null.INSTANCE));
        } else {
            ret.add("values", (SEXP)new DoubleArrayVector(wR));
            ret.add("vectors", (SEXP)(vectors ? DoubleArrayVector.newMatrix(right, n, n) : Null.INSTANCE));
        }
        return ret.build();
    }

    private static boolean thereAreComplexResults(int n, double[] wR, double[] wI) {
        boolean complexValues = false;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(wI[i]) > 2.220446E-15 * Math.abs(wR[i]))) continue;
            complexValues = true;
            break;
        }
        return complexValues;
    }

    public static ComplexVector c(double ... d) {
        ComplexArrayVector.Builder builder = new ComplexArrayVector.Builder();
        for (double di : d) {
            builder.add(ComplexVector.complex(di));
        }
        return builder.build();
    }

    public static Complex complex(double x, double y) {
        return ComplexVector.complex(x, y);
    }

    public static Complex complex(double x) {
        return Lapack.complex(x, 0.0);
    }

    protected static Complex[] row(Complex ... z) {
        return z;
    }

    protected static SEXP matrix(Complex[] ... rows) {
        ComplexArrayVector.Builder matrix2 = new ComplexArrayVector.Builder();
        int nrows = rows.length;
        int ncols = rows[0].length;
        for (int j = 0; j != ncols; ++j) {
            for (int i = 0; i != nrows; ++i) {
                matrix2.add(rows[i][j]);
            }
        }
        return matrix2.build();
    }

    private static int getSquareMatrixSize(SEXP x) {
        Vector xdims = (Vector)x.getAttribute(Symbols.DIM);
        if (xdims.length() != 2 || xdims.getElementAsInt(0) != xdims.getElementAsInt(1)) {
            throw new EvalException("'x' must be a square numeric matrix", new Object[0]);
        }
        int n = xdims.getElementAsInt(0);
        return n;
    }

    private static class ComplexEntry
    implements Comparable<ComplexEntry> {
        public Complex z;
        public double[] vector;

        public ComplexEntry(Complex z, double[] vector2) {
            this.z = z;
            this.vector = vector2;
        }

        @Override
        public int compareTo(ComplexEntry that) {
            Complex o1 = this.z;
            Complex o2 = that.z;
            if (o1.getImaginary() == 0.0 && o2.getImaginary() != 0.0) {
                return -1;
            }
            if (o1.getImaginary() != 0.0 && o2.getImaginary() == 0.0) {
                return 1;
            }
            return (int)(ComplexGroup.Mod(o2) - ComplexGroup.Mod(o1));
        }

        public static Complex[] getEigenvalues(int n, List<ComplexEntry> complex2) {
            Complex[] eigenvalues = new Complex[n];
            for (int i = 0; i < n; ++i) {
                eigenvalues[i] = complex2.get((int)i).z;
            }
            return eigenvalues;
        }

        public static Complex[] getEigenvectors(List<ComplexEntry> complexes) {
            int n = complexes.size();
            Complex[] result = new Complex[n * n];
            for (int j = 0; j < n; ++j) {
                int index;
                Complex z = complexes.get((int)j).z;
                if (z.getImaginary() == 0.0) {
                    for (index = 0; index < n; ++index) {
                        result[n * j + index] = Lapack.complex(complexes.get((int)j).vector[index]);
                    }
                    continue;
                }
                if (j + 1 < n && ComplexEntry.isConjugate(z, complexes.get((int)(j + 1)).z)) {
                    for (index = 0; index < n; ++index) {
                        result[n * j + index] = Lapack.complex(complexes.get((int)j).vector[index], complexes.get((int)(j + 1)).vector[index]);
                    }
                    continue;
                }
                if (j > 0 && ComplexEntry.isConjugate(z, complexes.get((int)(j - 1)).z)) {
                    for (index = 0; index < n; ++index) {
                        result[n * j + index] = Lapack.complex(complexes.get((int)(j - 1)).vector[index], -1.0 * complexes.get((int)j).vector[index]);
                    }
                    continue;
                }
                assert (false) : "This should never happen!";
            }
            return result;
        }

        private static boolean isConjugate(Complex z, Complex w) {
            return z.getReal() == w.getReal() && z.getImaginary() == -1.0 * w.getImaginary();
        }
    }
}

