/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.Iterator;
import java.util.List;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;

public class ConstantCall
implements Specialization {
    private Object constantValue;
    private Type type;
    private ValueBounds valueBounds;

    public ConstantCall(Object constantValue) {
        this.constantValue = constantValue;
        if (constantValue instanceof Integer) {
            this.type = Type.INT_TYPE;
            this.valueBounds = ValueBounds.of(IntVector.valueOf((Integer)constantValue));
        } else if (constantValue instanceof Double) {
            this.type = Type.DOUBLE_TYPE;
            this.valueBounds = ValueBounds.of(DoubleVector.valueOf((Double)constantValue));
        } else {
            throw new UnsupportedOperationException("constantValue: " + constantValue);
        }
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        if (this.constantValue instanceof Integer) {
            mv.iconst(((Integer)this.constantValue).intValue());
        } else if (this.constantValue instanceof Double) {
            mv.dconst(((Double)this.constantValue).doubleValue());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public static ConstantCall evaluate(JvmMethod method, List<ValueBounds> arguments) {
        Object constantValue;
        List<JvmMethod.Argument> formals2 = method.getAllArguments();
        Object[] args2 = new Object[formals2.size()];
        for (int i = 0; i < formals2.size(); ++i) {
            method.getAllArguments();
        }
        Iterator<ValueBounds> it = arguments.iterator();
        int argI = 0;
        for (JvmMethod.Argument formal : formals2) {
            if (formal.isContextual() || formal.isVarArg() || formal.isNamedFlag()) {
                throw new UnsupportedOperationException("formal: " + formal);
            }
            ValueBounds argument = it.next();
            args2[argI++] = argument.getConstantValue();
        }
        try {
            constantValue = method.getMethod().invoke(null, args2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ConstantCall(constantValue);
    }
}

