/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir;

import java.util.Iterator;
import org.renjin.compiler.ir.TypeSet;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;

public class ValueBounds {
    public static final int UNKNOWN_LENGTH = -1;
    public static final int SCALAR_LENGTH = 1;
    public static final ValueBounds UNBOUNDED = new ValueBounds();
    public static final ValueBounds INT_PRIMITIVE = ValueBounds.primitive(8);
    public static final ValueBounds DOUBLE_PRIMITIVE = ValueBounds.primitive(16);
    public static final ValueBounds LOGICAL_PRIMITIVE = ValueBounds.primitive(32);
    private int length = -1;
    private int typeSet = 8190;
    private SEXP constantValue = null;
    private AtomicVector constantClassAttribute = null;
    private AttributeMap constantAttributes = null;

    private ValueBounds() {
    }

    private ValueBounds(ValueBounds toCopy) {
        this.length = toCopy.length;
        this.typeSet = toCopy.typeSet;
        this.constantValue = toCopy.constantValue;
        this.constantAttributes = toCopy.constantAttributes;
        this.constantClassAttribute = toCopy.constantClassAttribute;
    }

    public static ValueBounds primitive(int type) {
        ValueBounds valueBounds = new ValueBounds();
        valueBounds.typeSet = type;
        valueBounds.length = 1;
        valueBounds.constantClassAttribute = Null.INSTANCE;
        valueBounds.constantAttributes = AttributeMap.EMPTY;
        return valueBounds;
    }

    public static ValueBounds of(SEXP value) {
        ValueBounds valueBounds = new ValueBounds();
        valueBounds.constantValue = value;
        valueBounds.typeSet = TypeSet.of(value);
        valueBounds.length = value.length();
        valueBounds.constantClassAttribute = value.getAttributes().getClassVector();
        valueBounds.constantAttributes = value.getAttributes();
        return valueBounds;
    }

    public ValueBounds of(Object value) {
        if (value instanceof SEXP) {
            return ValueBounds.of((SEXP)value);
        }
        if (value instanceof Integer) {
            return ValueBounds.of(IntVector.valueOf((Integer)value));
        }
        if (value instanceof Double) {
            return ValueBounds.of(DoubleVector.valueOf((Double)value));
        }
        throw new UnsupportedOperationException("value: " + value);
    }

    public static ValueBounds of(Class returnType) {
        ValueBounds valueBounds = new ValueBounds();
        valueBounds.typeSet = TypeSet.of(returnType);
        valueBounds.length = returnType.isPrimitive() ? 1 : -1;
        return valueBounds;
    }

    public ValueBounds withAttributes(AttributeMap attributes2) {
        ValueBounds bounds = new ValueBounds(this);
        bounds.constantAttributes = attributes2;
        bounds.constantClassAttribute = attributes2.getClassVector();
        return bounds;
    }

    public boolean isConstant() {
        return this.constantValue != null;
    }

    public boolean isLengthConstant() {
        return this.length != -1;
    }

    public boolean isClassAttributeConstant() {
        return this.constantClassAttribute != null;
    }

    public boolean isAttributeConstant() {
        return this.constantAttributes != null;
    }

    public AtomicVector getConstantClassAttribute() {
        if (this.constantClassAttribute == null) {
            throw new IllegalStateException("class attribute is not constant");
        }
        return this.constantClassAttribute;
    }

    public AttributeMap getConstantAttributes() {
        if (this.constantAttributes == null) {
            throw new IllegalArgumentException("attributes are not constant");
        }
        return this.constantAttributes;
    }

    public int getTypeSet() {
        return this.typeSet;
    }

    public int getLength() {
        return this.length;
    }

    public ValueBounds union(ValueBounds other) {
        ValueBounds u = new ValueBounds();
        u.typeSet = this.typeSet | other.typeSet;
        u.length = ValueBounds.unionLengths(this.length, other.length);
        u.constantClassAttribute = this.unionConstant(this.constantClassAttribute, other.constantClassAttribute);
        u.constantAttributes = this.unionConstant(this.constantAttributes, other.constantAttributes);
        return u;
    }

    private static int unionLengths(int x, int y) {
        if (x == y) {
            return x;
        }
        return -1;
    }

    private <T> T unionConstant(T x, T y) {
        if (x == null || y == null) {
            return null;
        }
        if (x.equals(y)) {
            return x;
        }
        return null;
    }

    public static ValueBounds union(Iterable<ValueBounds> bounds) {
        Iterator<ValueBounds> it = bounds.iterator();
        Preconditions.checkArgument((boolean)it.hasNext());
        ValueBounds union = it.next();
        while (it.hasNext()) {
            union = union.union(it.next());
        }
        return union;
    }

    public static ValueBounds vector(int types) {
        ValueBounds bounds = new ValueBounds();
        bounds.typeSet = types;
        bounds.length = -1;
        return bounds;
    }

    public static ValueBounds vector(Class type) {
        return ValueBounds.vector(TypeSet.of(type));
    }

    public static ValueBounds vector(Class type, int length2) {
        ValueBounds bounds = new ValueBounds();
        bounds.typeSet = TypeSet.of(type);
        bounds.length = length2;
        return bounds;
    }

    public static ValueBounds vector(int typeSet, int length2) {
        ValueBounds bounds = new ValueBounds();
        bounds.typeSet = typeSet;
        bounds.length = length2;
        return bounds;
    }

    public Type storageType() {
        if (this.typeSet == 16) {
            if (this.length == 1) {
                return Type.DOUBLE_TYPE;
            }
            return Type.getType(DoubleVector.class);
        }
        if (this.typeSet == 8 || this.typeSet == 32) {
            if (this.length == 1) {
                return Type.INT_TYPE;
            }
            return Type.getType(IntVector.class);
        }
        if (this.typeSet == 256) {
            if (this.length == 1) {
                return Type.BYTE_TYPE;
            }
            return Type.getType(RawVector.class);
        }
        if (this.typeSet == 64) {
            if (this.length == 1) {
                return Type.getType(String.class);
            }
            return Type.getType(StringVector.class);
        }
        return Type.getType(SEXP.class);
    }

    public String toString() {
        if (this.isConstant()) {
            return "[const " + this.formatConstant(this.constantValue) + "]";
        }
        if (this.typeSet == 8190 && this.length == -1) {
            return "[*]";
        }
        StringBuilder s = new StringBuilder();
        s.append("[");
        s.append(TypeSet.toString(this.typeSet));
        s.append(", len=");
        if (this.length == -1) {
            s.append("*");
        } else {
            s.append(this.length);
        }
        if (this.constantAttributes == null) {
            if (this.constantClassAttribute == null) {
                s.append(", class=?");
            } else if (this.constantClassAttribute == Null.INSTANCE) {
                s.append(", class=\u2205");
            } else {
                s.append(", class={").append(this.constantClassAttribute).append("}");
            }
        } else if (this.constantAttributes == AttributeMap.EMPTY) {
            s.append(", attr=\u2205");
        } else {
            s.append(", attr={");
            this.appendAttributesTo(s, this.constantAttributes);
            s.append("}");
        }
        s.append("]");
        return s.toString();
    }

    private String formatConstant(SEXP constantValue) {
        StringBuilder s = new StringBuilder(this.formatConstantValue(constantValue));
        AttributeMap attributes2 = constantValue.getAttributes();
        this.appendAttributesTo(s, attributes2);
        return s.toString();
    }

    private void appendAttributesTo(StringBuilder s, AttributeMap attributes2) {
        if (attributes2 != AttributeMap.EMPTY) {
            for (PairList.Node node : attributes2.nodes()) {
                s.append(", ").append(node.getTag().getPrintName()).append("=").append(this.formatConstant(node.getValue()));
            }
        }
    }

    private String formatConstantValue(SEXP constantValue) {
        IntSequence seq2;
        if (constantValue.length() == 1) {
            if (constantValue instanceof IntVector) {
                return ((IntVector)constantValue).getElementAsInt(0) + "L";
            }
            if (constantValue instanceof DoubleVector) {
                return Double.toString(((DoubleVector)constantValue).getElementAsDouble(0));
            }
        }
        if (constantValue instanceof IntSequence && (seq2 = (IntSequence)constantValue).getBy() == 1) {
            return seq2.getFrom() + ":" + (seq2.getFrom() + seq2.getLength());
        }
        return constantValue.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueBounds that = (ValueBounds)o;
        return this.length == that.length && this.typeSet == that.typeSet;
    }

    public int hashCode() {
        int result = this.length;
        result = 31 * result + this.typeSet;
        return result;
    }

    public SEXP getConstantValue() {
        return this.constantValue;
    }

    public static boolean allConstant(Iterable<ValueBounds> argumentTypes) {
        for (ValueBounds argumentType : argumentTypes) {
            if (argumentType.isConstant()) continue;
            return false;
        }
        return true;
    }
}

