/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.List;
import java.util.Map;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.cfg.InlinedFunction;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.InlineParamExpr;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.IRMatchedArguments;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.sexp.Closure;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class ClosureCall
implements Expression {
    private RuntimeState runtimeState;
    private final FunctionCall call;
    private final List<IRArgument> arguments;
    private Closure closure;
    private IRMatchedArguments matching;
    private InlinedFunction inlinedFunction;
    private ValueBounds returnBounds;
    private Type type;

    public ClosureCall(RuntimeState runtimeState, FunctionCall call2, Closure closure, List<IRArgument> arguments) {
        this.runtimeState = runtimeState;
        this.call = call2;
        this.closure = closure;
        this.arguments = arguments;
        this.matching = new IRMatchedArguments(closure, arguments);
        this.returnBounds = ValueBounds.UNBOUNDED;
        this.type = this.returnBounds.storageType();
    }

    @Override
    public boolean isDefinitelyPure() {
        return false;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        if (this.inlinedFunction == null) {
            try {
                this.inlinedFunction = new InlinedFunction(this.runtimeState, this.closure, this.matching.getSuppliedFormals());
            }
            catch (NotCompilableException e) {
                throw new NotCompilableException(this.call, e);
            }
        }
        if (this.matching.hasExtraArguments()) {
            throw new NotCompilableException((SEXP)this.call, "Extra arguments not supported");
        }
        for (int i = 0; i < this.arguments.size(); ++i) {
            Expression argumentExpr = this.arguments.get(i).getExpression();
            ValueBounds argumentBounds = typeMap.get(argumentExpr);
            this.inlinedFunction.updateParam(i, argumentBounds);
        }
        this.returnBounds = this.inlinedFunction.computeBounds();
        this.type = this.returnBounds.storageType();
        return this.returnBounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.returnBounds;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        if (this.matching.hasExtraArguments()) {
            throw new NotCompilableException((SEXP)this.call, "Extra arguments not supported");
        }
        EmitContext inlineContext = emitContext.inlineContext(this.inlinedFunction.getCfg(), this.inlinedFunction.getTypes());
        for (Map.Entry<Symbol, Integer> formal : this.matching.getMatchedFormals().entrySet()) {
            inlineContext.setInlineParameter(formal.getKey(), new InlineParamExpr(emitContext, this.arguments.get(formal.getValue()).getExpression()));
        }
        this.inlinedFunction.writeInline(inlineContext, mv);
        return 0;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        this.arguments.get(childIndex).setExpression(child);
    }

    @Override
    public int getChildCount() {
        return this.arguments.size();
    }

    @Override
    public Expression childAt(int index) {
        return this.arguments.get(index).getExpression();
    }

    public String toString() {
        return this.functionName() + "(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    private String functionName() {
        if (this.call.getFunction() instanceof Symbol) {
            return ((Symbol)this.call.getFunction()).getPrintName();
        }
        return "fn";
    }
}

