/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.InlineParamExpr;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.Symbol;

public class ReadParam
implements Expression {
    private final Symbol param;
    private ValueBounds valueBounds;
    private Type type;

    public ReadParam(Symbol param) {
        this.param = param;
        this.valueBounds = ValueBounds.UNBOUNDED;
        this.type = this.valueBounds.storageType();
    }

    public Symbol getParam() {
        return this.param;
    }

    @Override
    public boolean isDefinitelyPure() {
        return true;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        InlineParamExpr paramaterValue = emitContext.getInlineParameter(this.param);
        paramaterValue.load(mv);
        return 0;
    }

    @Override
    public Type getType() {
        return this.type.getReturnType();
    }

    public void updateBounds(ValueBounds argumentBounds) {
        this.valueBounds = argumentBounds;
        this.type = argumentBounds.storageType();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        return this.valueBounds;
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        throw new IllegalArgumentException("no children");
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Expression childAt(int index) {
        throw new IllegalArgumentException("no children");
    }

    public String toString() {
        return "param(" + this.param + ")";
    }
}

