/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Collections;
import java.util.List;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.codegen.VariableStorage;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Environment;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class ReturnStatement
implements Statement,
BasicBlockEndingStatement {
    private Expression returnValue;
    private List<Symbol> environmentVariableNames = Lists.newArrayList();
    private List<Expression> environmentVariables = Lists.newArrayList();

    public ReturnStatement(Expression returnValue) {
        this.returnValue = returnValue;
    }

    public Expression getReturnValue() {
        return this.returnValue;
    }

    @Override
    public Expression getRHS() {
        return this.returnValue;
    }

    @Override
    public void setRHS(Expression newRHS) {
        this.returnValue = newRHS;
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Collections.emptySet();
    }

    public void addEnvironmentVariables(Iterable<EnvironmentVariable> variables) {
        for (EnvironmentVariable variable : variables) {
            this.addEnvironmentVariable(variable.getName(), variable);
        }
    }

    public void addEnvironmentVariable(Symbol symbol2, LValue lValue) {
        this.environmentVariableNames.add(symbol2);
        this.environmentVariables.add(lValue);
    }

    @Override
    public int getChildCount() {
        return 1 + this.environmentVariableNames.size();
    }

    @Override
    public Expression childAt(int index) {
        if (index == 0) {
            return this.returnValue;
        }
        return this.environmentVariables.get(index - 1);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex == 0) {
            this.returnValue = child;
        } else {
            this.environmentVariables.set(childIndex - 1, child);
        }
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitReturn(this);
    }

    @Override
    public int emit(EmitContext emitContext, InstructionAdapter mv) {
        for (int i = 0; i < this.environmentVariableNames.size(); ++i) {
            VariableStorage variableStorage = emitContext.getVariableStorage((LValue)this.environmentVariables.get(i));
            if (variableStorage == null) continue;
            mv.load(emitContext.getEnvironmentVarIndex(), Type.getType(Environment.class));
            mv.aconst((Object)this.environmentVariableNames.get(i).getPrintName());
            mv.load(variableStorage.getSlotIndex(), variableStorage.getType());
            emitContext.convert(mv, variableStorage.getType(), Type.getType(SEXP.class));
            if (variableStorage.getType().getSort() != 10) {
                ValueBounds bounds = this.environmentVariables.get(i).getValueBounds();
                if (bounds.isAttributeConstant()) {
                    if (bounds.getConstantAttributes() != AttributeMap.EMPTY) {
                        this.generateAttributes(mv, bounds.getConstantAttributes());
                    }
                } else {
                    throw new UnsupportedOperationException("Lost attributes");
                }
            }
            mv.invokevirtual(Type.getInternalName(Environment.class), "setVariableUnsafe", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(SEXP.class)}), false);
        }
        mv.areturn(Type.VOID_TYPE);
        return 0;
    }

    private void generateAttributes(InstructionAdapter mv, AttributeMap constantAttributes) {
        Type builderType = Type.getType(AttributeMap.Builder.class);
        mv.invokestatic(Type.getInternalName(AttributeMap.class), "newBuilder", Type.getMethodDescriptor((Type)builderType, (Type[])new Type[0]), false);
        for (PairList.Node node : constantAttributes.nodes()) {
            if (node.getTag() == Symbols.CLASS) {
                this.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setClass", Type.getMethodDescriptor((Type)builderType, (Type[])new Type[]{Type.getType(SEXP.class)}), false);
                continue;
            }
            if (node.getTag() == Symbols.NAMES) {
                this.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setNames", Type.getMethodDescriptor((Type)builderType, (Type[])new Type[]{Type.getType(SEXP.class)}), false);
                continue;
            }
            if (node.getTag() == Symbols.DIM) {
                this.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setDim", Type.getMethodDescriptor((Type)builderType, (Type[])new Type[]{Type.getType(SEXP.class)}), false);
                continue;
            }
            if (node.getTag() == Symbols.DIMNAMES) {
                this.pushConstant(mv, node.getValue());
                mv.invokevirtual(builderType.getInternalName(), "setDimNames", Type.getMethodDescriptor((Type)builderType, (Type[])new Type[]{Type.getType(SEXP.class)}), false);
                continue;
            }
            mv.aconst((Object)node.getTag().getPrintName());
            this.pushConstant(mv, node.getValue());
            mv.invokevirtual(builderType.getInternalName(), "set", Type.getMethodDescriptor((Type)builderType, (Type[])new Type[]{Type.getType(String.class), Type.getType(SEXP.class)}), false);
        }
        mv.invokeinterface(Type.getInternalName(SEXP.class), "setAttributes", Type.getMethodDescriptor((Type)Type.getType(SEXP.class), (Type[])new Type[]{builderType}));
    }

    private void pushConstant(InstructionAdapter mv, SEXP value) {
        if (value instanceof StringVector && value.length() == 1) {
            mv.visitLdcInsn((Object)((StringVector)value).getElementAsString(0));
            mv.invokestatic(Type.getInternalName(StringVector.class), "valueOf", Type.getMethodDescriptor((Type)Type.getType(StringVector.class), (Type[])new Type[]{Type.getType(String.class)}), false);
            return;
        }
        throw new UnsupportedOperationException("TODO: constant = " + value);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("return ");
        s.append(this.returnValue);
        for (int i = 0; i < this.environmentVariableNames.size(); ++i) {
            s.append(", ");
            s.append(this.environmentVariableNames.get(i));
            s.append(" = ");
            s.append(this.environmentVariables.get(i));
        }
        return s.toString();
    }
}

