/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.optimize;

import org.renjin.compiler.pipeline.DeferredGraph;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.optimize.Optimizer;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class SquareOptimizer
implements Optimizer {
    @Override
    public boolean optimize(DeferredGraph graph, DeferredNode node) {
        if (this.isEligible(node)) {
            DeferredNode operand = node.getOperand(0);
            node.replaceVector(new Square(operand.getVector(), operand.getVector().getAttributes()));
            node.replaceOperands(operand);
            return true;
        }
        return false;
    }

    private boolean isEligible(DeferredNode node) {
        return node.isComputation() && node.getComputation().getComputationName().equals("*") && node.getOperand(0) == node.getOperand(1);
    }

    public static class Square
    extends DoubleVector
    implements DeferredComputation {
        private Vector vector;

        protected Square(Vector vector2, AttributeMap attributes2) {
            super(attributes2);
            this.vector = vector2;
        }

        @Override
        public Vector[] getOperands() {
            return new Vector[]{this.vector};
        }

        @Override
        public String getComputationName() {
            return "sqr";
        }

        @Override
        protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
            return new Square(this.vector, attributes2);
        }

        @Override
        public double getElementAsDouble(int index) {
            return Square.compute(this.vector.getElementAsDouble(index));
        }

        @Override
        public boolean isConstantAccessTime() {
            return true;
        }

        @Override
        public int length() {
            return this.vector.length();
        }

        public static double compute(double x) {
            return x * x;
        }

        @Override
        public boolean isDeferred() {
            return true;
        }
    }
}

