/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.Map;
import java.util.Set;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;

public class Options {
    private Map<String, SEXP> map = Maps.newHashMap();

    public Options() {
        this.map.put("prompt", new StringArrayVector("> "));
        this.map.put("continue", new StringArrayVector("+ "));
        this.map.put("expressions", new IntArrayVector(5000));
        this.map.put("width", new IntArrayVector(80));
        this.map.put("digits", new IntArrayVector(7));
        this.map.put("echo", new LogicalArrayVector(false));
        this.map.put("verbose", new LogicalArrayVector(false));
        this.map.put("check.bounds", new LogicalArrayVector(false));
        this.map.put("keep.source", new LogicalArrayVector(true));
        this.map.put("keep.source.pkgs", new LogicalArrayVector(false));
        this.map.put("warnings.length", new IntArrayVector(1000));
        this.map.put("OutDec", new StringArrayVector("."));
    }

    public SEXP get(String name) {
        SEXP value = this.map.get(name);
        return value == null ? Null.INSTANCE : value;
    }

    public int getInt(String name, int defaultValue) {
        SEXP value = this.get(name);
        if (value instanceof AtomicVector && value.length() >= 1) {
            return ((AtomicVector)value).getElementAsInt(0);
        }
        return defaultValue;
    }

    public SEXP set(String name, SEXP value) {
        SEXP old = this.map.put(name, value);
        return old == null ? Null.INSTANCE : value;
    }

    public Set<String> names() {
        return this.map.keySet();
    }
}

