/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.util.List;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.Session;
import org.renjin.invoke.codegen.ApplyMethodContext;
import org.renjin.invoke.codegen.GeneratorDefinitionException;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ListVector;

public class VarArgParser {
    private ApplyMethodContext methodContext;
    private JBlock parent;
    private JvmMethod overload;
    private JVar varArgBuilder;
    private JVar varArgList;
    private List<JExpression> arguments = Lists.newArrayList();
    private List<PositionalArg> positionalArguments = Lists.newArrayList();
    private Map<JvmMethod.Argument, JVar> namedFlags = Maps.newHashMap();
    private JBlock argumentProcessingBlock;

    public VarArgParser(ApplyMethodContext methodContext, JBlock parent2, JvmMethod overload) {
        this.methodContext = methodContext;
        this.parent = parent2;
        this.overload = overload;
        boolean varArgsSeen = false;
        this.varArgBuilder = parent2.decl((JType)this.classRef(ListVector.NamedBuilder.class), "varArgs", (JExpression)JExpr._new((JClass)this.classRef(ListVector.NamedBuilder.class)));
        this.varArgList = parent2.decl((JType)this.classRef(ListVector.class), "varArgList");
        for (JvmMethod.Argument formal : this.overload.getAllArguments()) {
            if (formal.isContextual()) {
                this.arguments.add(this.contextualExpression(formal));
                continue;
            }
            if (formal.isVarArg()) {
                this.arguments.add((JExpression)this.varArgList);
                varArgsSeen = true;
                continue;
            }
            if (formal.isNamedFlag()) {
                JVar flag = parent2.decl(this.argumentType(formal), this.nextFlagName(), this.defaultValueExpression(formal));
                this.namedFlags.put(formal, flag);
                this.arguments.add((JExpression)flag);
                continue;
            }
            if (varArgsSeen) {
                throw new GeneratorDefinitionException("Any argument following a @ArgumentList must be annotated with @NamedFlag");
            }
            JVar arg = parent2.decl(this.argumentType(formal), this.nextPosName(formal));
            this.arguments.add((JExpression)arg);
            this.positionalArguments.add(new PositionalArg(formal, arg));
        }
        this.argumentProcessingBlock = parent2.block();
        parent2.block().assign((JAssignmentTarget)this.varArgList, (JExpression)this.varArgBuilder.invoke("build"));
    }

    private JExpression contextualExpression(JvmMethod.Argument formal) {
        if (formal.getClazz().equals(Context.class)) {
            return this.methodContext.getContext();
        }
        if (formal.getClazz().equals(Environment.class)) {
            return this.methodContext.getEnvironment();
        }
        if (formal.getClazz().equals(Session.class)) {
            return this.methodContext.getContext().invoke("getSession");
        }
        throw new RuntimeException("Invalid contextual argument type: " + formal.getClazz());
    }

    private JClass classRef(Class clazz) {
        return this.methodContext.classRef(clazz);
    }

    private JExpression defaultValueExpression(JvmMethod.Argument argument) {
        if (argument.getClazz().equals(Boolean.TYPE)) {
            return argument.getDefaultValue() ? JExpr.TRUE : JExpr.FALSE;
        }
        if (!argument.getClazz().isPrimitive()) {
            return JExpr._null();
        }
        throw new UnsupportedOperationException("Don't know how to define default value for " + argument);
    }

    private JType argumentType(JvmMethod.Argument argument) {
        return this.methodContext.getCodeModel()._ref(argument.getClazz());
    }

    private String nextPosName(JvmMethod.Argument argument) {
        return "pos" + argument.getIndex();
    }

    private String nextFlagName() {
        return "flag" + this.namedFlags.size();
    }

    public List<PositionalArg> getPositionalArguments() {
        return this.positionalArguments;
    }

    public List<JExpression> getArguments() {
        return this.arguments;
    }

    public JVar getVarArgBuilder() {
        return this.varArgBuilder;
    }

    public JExpression getVarArgList() {
        return this.varArgList;
    }

    public Map<JvmMethod.Argument, JVar> getNamedFlags() {
        return this.namedFlags;
    }

    public JExpression getNamedFlagJExp(String name) {
        for (Map.Entry<JvmMethod.Argument, JVar> flag : this.namedFlags.entrySet()) {
            if (!flag.getKey().getName().equals(name)) continue;
            return (JExpression)flag.getValue();
        }
        throw new UnsupportedOperationException("not such named flag: " + name);
    }

    public JBlock getArgumentProcessingBlock() {
        return this.argumentProcessingBlock;
    }

    public static class PositionalArg {
        private final JvmMethod.Argument formal;
        private final JVar variable;

        public PositionalArg(JvmMethod.Argument formal, JVar variable) {
            this.formal = formal;
            this.variable = variable;
        }

        public JvmMethod.Argument getFormal() {
            return this.formal;
        }

        public JVar getVariable() {
            return this.variable;
        }
    }
}

