/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.codegen;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JPackage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.renjin.invoke.annotations.CastStyle;
import org.renjin.invoke.codegen.InvokerGenerator;
import org.renjin.invoke.model.JvmMethod;
import org.renjin.invoke.model.PrimitiveModel;
import org.renjin.primitives.Primitives;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.io.Files;

public class WrapperGenerator2 {
    private File sourcesDir;
    private File outputDir;
    private String singleFunction;
    private boolean encounteredError = false;
    private List<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();

    public static void main(String[] args2) throws IOException {
        File baseDir = new File("");
        WrapperGenerator2 generator = new WrapperGenerator2(baseDir);
        if (args2.length > 0) {
            generator.setSingleFunction(args2[0]);
        }
        generator.generate();
        System.exit(generator.isSuccessful() ? 0 : 1);
    }

    public WrapperGenerator2(File baseDir) {
        this.sourcesDir = new File(baseDir.getAbsoluteFile() + File.separator + "target" + File.separator + "generated-sources" + File.separator + "r-wrappers" + File.separator);
        this.sourcesDir.mkdirs();
        this.outputDir = new File(baseDir.getAbsoluteFile() + File.separator + "target" + File.separator + "classes");
    }

    public void setSingleFunction(String name) {
        this.singleFunction = name;
    }

    public void generate() throws IOException {
        this.generateSources();
        this.compile();
    }

    public boolean isSuccessful() {
        return !this.encounteredError;
    }

    private void generateSources() throws IOException {
        int implementedCount = 0;
        JCodeModel codeModel = new JCodeModel();
        List<Primitives.Entry> entries = Primitives.getEntries();
        for (Primitives.Entry entry : entries) {
            if (this.singleFunction != null && !this.singleFunction.equals(entry.name)) continue;
            List<JvmMethod> overloads = JvmMethod.findOverloads(entry.functionClass, entry.name, entry.methodName);
            if (overloads.isEmpty() && entry.functionClass != null) {
                System.err.println("WARNING: Can't find " + entry.functionClass.getName() + "." + (entry.methodName == null ? entry.name : entry.methodName));
            }
            if (!overloads.isEmpty()) {
                this.generate(codeModel, new PrimitiveModel(entry, overloads));
                ++implementedCount;
            }
            for (JvmMethod method : overloads) {
                if (!this.implicitIntCasting(method)) continue;
                System.out.println("IMPLICIT INT CASTING: " + method);
            }
        }
        codeModel.build(new CodeWriter(){

            public Writer openSource(JPackage pkg, String fileName) throws IOException {
                File pkgDir = new File(WrapperGenerator2.this.sourcesDir, pkg.name().replace('.', '/'));
                pkgDir.mkdirs();
                File sourceFile = new File(pkgDir, fileName);
                WrapperGenerator2.this.compilationUnits.add(new WrapperSource(sourceFile));
                return new FileWriter(sourceFile);
            }

            public OutputStream openBinary(JPackage jPackage, String s) throws IOException {
                throw new UnsupportedOperationException();
            }

            public void close() throws IOException {
            }
        });
        System.out.println("Total primitives: " + entries.size());
        System.out.println("   % Implemented: " + (double)implementedCount / (double)entries.size() * 100.0 + "%");
    }

    private boolean implicitIntCasting(JvmMethod method) {
        for (JvmMethod.Argument arg : method.getFormals()) {
            if (!arg.getClazz().equals(Integer.TYPE) || arg.getCastStyle() != CastStyle.IMPLICIT) continue;
            return true;
        }
        return false;
    }

    private void generate(JCodeModel codeModel, PrimitiveModel primitive2) throws IOException {
        try {
            InvokerGenerator generator = new InvokerGenerator(codeModel);
            generator.generate(primitive2);
        }
        catch (Exception e) {
            System.err.println("Error generating wrapper for '" + primitive2.getName() + "': " + e.getMessage());
            System.err.println("Overloads defined:");
            for (JvmMethod method : primitive2.getOverloads()) {
                System.err.println("  " + method.toString());
            }
            this.encounteredError = true;
            e.printStackTrace();
        }
    }

    public void compile() throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager jfm = compiler.getStandardFileManager(diagnostics, null, null);
        jfm.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(this.outputDir));
        JavaCompiler.CompilationTask task = compiler.getTask(null, jfm, diagnostics, Arrays.asList("-g", "-source", "1.6", "-target", "1.6"), null, this.compilationUnits);
        boolean success = task.call();
        if (!success) {
            System.err.println("Compilation failed: ");
            for (Diagnostic d : diagnostics.getDiagnostics()) {
                System.err.println(d.toString());
            }
            this.encounteredError = true;
        }
        jfm.close();
    }

    public static String toJavaName(String rName) {
        return WrapperGenerator2.toJavaName("R$primitive$", rName);
    }

    public static String toJavaName(String prefix, String rName) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix);
        rName = rName.replace('.', '$');
        rName = rName.replace("<-", "$assign");
        for (int i = 0; i != rName.length(); ++i) {
            int cp = rName.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) {
                sb.appendCodePoint(cp);
                continue;
            }
            if (cp == 61) {
                sb.append("$eq");
                continue;
            }
            if (cp == 62) {
                sb.append("$greater");
                continue;
            }
            if (cp == 60) {
                sb.append("$less");
                continue;
            }
            if (cp == 43) {
                sb.append("$plus");
                continue;
            }
            if (cp == 45) {
                sb.append("$minus");
                continue;
            }
            if (cp == 42) {
                sb.append("$times");
                continue;
            }
            if (cp == 47) {
                sb.append("$div");
                continue;
            }
            if (cp == 33) {
                sb.append("$bang");
                continue;
            }
            if (cp == 64) {
                sb.append("$at");
                continue;
            }
            if (cp == 35) {
                sb.append("$at");
                continue;
            }
            if (cp == 37) {
                sb.append("$percent");
                continue;
            }
            if (cp == 94) {
                sb.append("$up");
                continue;
            }
            if (cp == 38) {
                sb.append("$amp");
                continue;
            }
            if (cp == 126) {
                sb.append("$tilde");
                continue;
            }
            if (cp == 63) {
                sb.append("$qmark");
                continue;
            }
            if (cp == 124) {
                sb.append("$bar");
                continue;
            }
            if (cp == 92) {
                sb.append("$bslash");
                continue;
            }
            if (cp == 58) {
                sb.append("$colon");
                continue;
            }
            if (cp == 40) {
                sb.append("$paren");
                continue;
            }
            if (cp == 91) {
                sb.append("$bracket");
                continue;
            }
            sb.append("_$" + cp + "$_");
        }
        return sb.toString();
    }

    public static String toFullJavaName(String rName) {
        return "org.renjin.primitives." + WrapperGenerator2.toJavaName(rName);
    }

    private static class WrapperSource
    extends SimpleJavaFileObject {
        private File file;

        public WrapperSource(File file2) {
            super(file2.toURI(), JavaFileObject.Kind.SOURCE);
            this.file = file2;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            return Files.toString((File)this.file, (Charset)Charsets.UTF_8);
        }
    }
}

