/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.packaging;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.serialization.RDataReader;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Null;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;

public class SerializedPromise
extends Promise {
    private Function<String, InputStream> resourceProvider;
    private String name;

    public SerializedPromise(Function<String, InputStream> resourceProvider, String name) {
        super(Environment.EMPTY, (SEXP)Null.INSTANCE);
        this.resourceProvider = resourceProvider;
        this.name = name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected SEXP doEval(Context context) {
        try (RDataReader reader = new RDataReader(context, (InputStream)this.resourceProvider.apply((Object)SerializedPromise.resourceName(this.name)));){
            SEXP sEXP = reader.readFile();
            return sEXP;
        }
        catch (IOException e) {
            throw new EvalException(e);
        }
    }

    public static String resourceName(String symbolName) {
        if (symbolName.startsWith("._")) {
            symbolName = "$$" + symbolName;
        }
        symbolName = symbolName.replaceAll("/", Matcher.quoteReplacement("$$div$$"));
        return symbolName + ".RData";
    }
}

