/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Internal;
import org.renjin.repackaged.guava.annotations.VisibleForTesting;
import org.renjin.repackaged.guava.base.Objects;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class Identical {
    @Internal
    public static boolean identical(SEXP x, SEXP y, boolean numericallyEqual, boolean singleNA, boolean attributesAsSet, boolean ignoreByteCode) {
        if (!attributesAsSet) {
            throw new EvalException("identical implementation only supports attrib.as.set = TRUE", new Object[0]);
        }
        return Identical.identical(x, y, !numericallyEqual, !singleNA);
    }

    public static boolean identical(SEXP x, SEXP y) {
        return Identical.identical(x, y, false, false);
    }

    private static boolean identical(SEXP x, SEXP y, boolean bitwiseComparisonNumbers, boolean bitwiseComparisonNaN) {
        if (x == y) {
            return true;
        }
        if (x.length() != y.length()) {
            return false;
        }
        if (!x.getTypeName().equals(y.getTypeName())) {
            return false;
        }
        if (x instanceof AtomicVector) {
            return Identical.identicalAttributes(x, y) && Identical.identicalElements((AtomicVector)x, (AtomicVector)y, bitwiseComparisonNumbers, bitwiseComparisonNaN);
        }
        if (x instanceof ExpressionVector) {
            return Identical.identicalAttributes(x, y) && Identical.identicalElements((ListVector)x, (ListVector)y, bitwiseComparisonNumbers, bitwiseComparisonNaN);
        }
        if (x instanceof ListVector) {
            return Identical.identicalAttributes(x, y) && Identical.identicalElements((ListVector)x, (ListVector)y, bitwiseComparisonNumbers, bitwiseComparisonNaN);
        }
        if (x instanceof FunctionCall) {
            return Identical.identicalAttributes(x, y) && Identical.identicalElements((PairList)x, (PairList)y);
        }
        if (x instanceof PairList.Node) {
            return Identical.identicalAttributes(x, y) && Identical.identicalElements((PairList)x, (PairList)y);
        }
        if (x instanceof S4Object) {
            return Identical.identicalAttributes(x, y);
        }
        if (x instanceof ExternalPtr) {
            return Identical.identicalPointers((ExternalPtr)x, (ExternalPtr)y);
        }
        if (x instanceof Symbol || x instanceof Environment || x instanceof Function) {
            return x == y;
        }
        throw new UnsupportedOperationException("x = " + x.getClass() + ", y = " + y.getClass());
    }

    private static boolean identicalPointers(ExternalPtr x, ExternalPtr y) {
        return Objects.equal((Object)x, (Object)y);
    }

    private static boolean identicalElements(ListVector x, ListVector y, boolean bitwiseComparisonNumbers, boolean bitwiseComparisonNaN) {
        assert (x.length() == y.length());
        for (int i = 0; i != x.length(); ++i) {
            if (Identical.identical(x.getElementAsSEXP(i), y.getElementAsSEXP(i), bitwiseComparisonNumbers, bitwiseComparisonNaN)) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalElements(AtomicVector x, AtomicVector y, boolean bitwiseComparisonNumbers, boolean bitwiseComparisonNaN) {
        assert (x.length() == y.length());
        Vector.Type vectorType = x.getVectorType();
        if (y.getVectorType() != vectorType) {
            return false;
        }
        if (x instanceof DoubleVector) {
            return Identical.identicalDoubleElements((DoubleVector)x, (DoubleVector)y, bitwiseComparisonNumbers, bitwiseComparisonNaN);
        }
        if (x instanceof LogicalVector || x instanceof IntVector) {
            return Identical.identicalIntegerElements(x, y);
        }
        if (x instanceof StringVector) {
            return Identical.identicalStringElements(x, y);
        }
        if (x instanceof ComplexVector) {
            return Identical.identicalComplexElements(x, y, bitwiseComparisonNumbers, bitwiseComparisonNaN);
        }
        for (int i = 0; i != x.length(); ++i) {
            if (x.isElementNA(i) && y.isElementNA(i) || vectorType.elementsEqual(x, i, y, i)) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalStringElements(AtomicVector x, AtomicVector y) {
        assert (x.length() == y.length());
        for (int i = 0; i != x.length(); ++i) {
            String sy;
            String sx = x.getElementAsString(i);
            if (java.util.Objects.equals(sx, sy = y.getElementAsString(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalIntegerElements(AtomicVector x, AtomicVector y) {
        assert (x.length() == y.length());
        for (int i = 0; i != x.length(); ++i) {
            if (x.getElementAsInt(i) == y.getElementAsInt(i)) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalDoubleElements(DoubleVector x, DoubleVector y, boolean bitwiseComparisonNumbers, boolean bitwiseComparisonNaN) {
        assert (x.length() == y.length());
        for (int i = 0; i != x.length(); ++i) {
            if (Identical.equals(x.getElementAsDouble(i), y.getElementAsDouble(i), bitwiseComparisonNumbers, bitwiseComparisonNaN)) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalComplexElements(AtomicVector x, AtomicVector y, boolean bitwiseComparisonNumbers, boolean bitwiseComparisonNaN) {
        assert (x.length() == y.length());
        for (int i = 0; i != x.length(); ++i) {
            Complex xi = x.getElementAsComplex(i);
            Complex yi = y.getElementAsComplex(i);
            if (Identical.equals(xi.getReal(), yi.getReal(), bitwiseComparisonNumbers, bitwiseComparisonNaN) && Identical.equals(xi.getImaginary(), yi.getImaginary(), bitwiseComparisonNumbers, bitwiseComparisonNaN)) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalElements(PairList x, PairList y) {
        assert (x.length() == y.length());
        Iterator<PairList.Node> xi = x.nodes().iterator();
        Iterator<PairList.Node> yi = y.nodes().iterator();
        while (xi.hasNext()) {
            PairList.Node xni = xi.next();
            PairList.Node yni = yi.next();
            if (xni.getRawTag() == yni.getRawTag() && Identical.identical(xni.getValue(), yni.getValue(), false, false)) continue;
            return false;
        }
        return true;
    }

    private static boolean identicalAttributes(SEXP x, SEXP y) {
        AttributeMap ya;
        AttributeMap xa = x.getAttributes();
        if (xa == (ya = y.getAttributes())) {
            return true;
        }
        HashSet xan = Sets.newHashSet(xa.names());
        HashSet yan = Sets.newHashSet(ya.names());
        if (xan.size() != yan.size()) {
            return false;
        }
        for (Symbol name : xan) {
            if (Identical.identical(xa.get(name), ya.get(name), false, false)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean equals(double x, double y, boolean bitwiseComparisonNumbers, boolean bitwiseComparisonNaN) {
        if (Double.isNaN(x) || Double.isNaN(y)) {
            if (bitwiseComparisonNaN) {
                return Double.doubleToRawLongBits(x) == Double.doubleToRawLongBits(y);
            }
            if (DoubleVector.isNA(x)) {
                return DoubleVector.isNA(y);
            }
            if (DoubleVector.isNA(y)) {
                return false;
            }
            return Double.isNaN(x) && Double.isNaN(y);
        }
        if (bitwiseComparisonNumbers) {
            return Double.doubleToRawLongBits(x) == Double.doubleToRawLongBits(y);
        }
        return x == y;
    }
}

