/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.primitives.Special;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class R$primitive$besselY
extends BuiltinFunction {
    public R$primitive$besselY() {
        super("besselY");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            SEXP s1 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$besselY.doApply(context, environment2, s0, s1);
            }
            throw new EvalException("besselY: too many arguments, expected at most 2.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tbesselY(double, double)", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 2) {
                return R$primitive$besselY.doApply(context, environment2, args2[0], args2[1]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("besselY: max arity is 2", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$besselY.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0, SEXP arg1) throws Exception {
        if (arg0 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0) && arg1 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg1)) {
            int cycles;
            Vector vector0 = WrapperRuntime.convertToVector(arg0);
            int length0 = vector0.length();
            int currentElementIndex0 = 0;
            Vector vector1 = WrapperRuntime.convertToVector(arg1);
            int length1 = vector1.length();
            int currentElementIndex1 = 0;
            if (length0 == 0 || length1 == 0) {
                cycles = 0;
            } else {
                cycles = 0;
                if (length0 > cycles) {
                    cycles = length0;
                }
                if (length1 > cycles) {
                    cycles = length1;
                }
            }
            double[] array2 = new double[cycles];
            for (int i = 0; i != cycles; ++i) {
                double s0 = vector0.getElementAsDouble(currentElementIndex0);
                double s1 = vector1.getElementAsDouble(currentElementIndex1);
                array2[i] = Double.isNaN(s0) || Double.isNaN(s1) ? DoubleVector.NA : Special.besselY(s0, s1);
                if (++currentElementIndex0 == length0) {
                    currentElementIndex0 = 0;
                }
                if (++currentElementIndex1 != length1) continue;
                currentElementIndex1 = 0;
            }
            return new DoubleArrayVector(array2, AttributeMap.combineStructuralAttributes(vector0, vector1));
        }
        throw new EvalException(String.format("Invalid argument:\n\tbesselY(%s, %s)\n\tExpected:\n\tbesselY(double, double)", arg0.getTypeName(), arg1.getTypeName()), new Object[0]);
    }
}

