/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.Distributions;

public class R$primitive$pnchisq
extends BuiltinFunction {
    public R$primitive$pnchisq() {
        super("pnchisq");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            SEXP s1 = argIt.evalNext();
            SEXP s2 = argIt.evalNext();
            SEXP s3 = argIt.evalNext();
            SEXP s4 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$pnchisq.doApply(context, environment2, s0, s1, s2, s3, s4);
            }
            throw new EvalException("pnchisq: too many arguments, expected at most 5.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tpnchisq(double, double, double, logical, logical)", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 5) {
                return R$primitive$pnchisq.doApply(context, environment2, args2[0], args2[1], args2[2], args2[3], args2[4]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("pnchisq: max arity is 5", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$pnchisq.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0, SEXP arg1, SEXP arg2, SEXP arg3, SEXP arg4) throws Exception {
        if (arg0 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0) && arg1 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg1) && arg2 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg2) && arg3 instanceof Vector && arg4 instanceof Vector) {
            int cycles;
            Vector vector0 = WrapperRuntime.convertToVector(arg0);
            int length0 = vector0.length();
            int currentElementIndex0 = 0;
            Vector vector1 = WrapperRuntime.convertToVector(arg1);
            int length1 = vector1.length();
            int currentElementIndex1 = 0;
            Vector vector2 = WrapperRuntime.convertToVector(arg2);
            int length2 = vector2.length();
            int currentElementIndex2 = 0;
            Vector vector3 = WrapperRuntime.convertToVector(arg3);
            int length3 = vector3.length();
            int currentElementIndex3 = 0;
            Vector vector4 = WrapperRuntime.convertToVector(arg4);
            int length4 = vector4.length();
            int currentElementIndex4 = 0;
            if (length0 == 0 || length1 == 0 || length2 == 0 || length3 == 0 || length4 == 0) {
                cycles = 0;
            } else {
                cycles = 0;
                if (length0 > cycles) {
                    cycles = length0;
                }
                if (length1 > cycles) {
                    cycles = length1;
                }
                if (length2 > cycles) {
                    cycles = length2;
                }
                if (length3 > cycles) {
                    cycles = length3;
                }
                if (length4 > cycles) {
                    cycles = length4;
                }
            }
            DoubleArrayVector.Builder builder = new DoubleArrayVector.Builder(cycles);
            for (int i = 0; i != cycles; ++i) {
                double s0 = vector0.getElementAsDouble(currentElementIndex0);
                double s1 = vector1.getElementAsDouble(currentElementIndex1);
                double s2 = vector2.getElementAsDouble(currentElementIndex2);
                int s3 = vector3.getElementAsRawLogical(currentElementIndex3);
                int s4 = vector4.getElementAsRawLogical(currentElementIndex4);
                if (Double.isNaN(s0) || Double.isNaN(s1) || Double.isNaN(s2) || LogicalVector.isNA(s3) || LogicalVector.isNA(s4)) {
                    builder.setNA(i);
                } else {
                    builder.set(i, Distributions.pnchisq(s0, s1, s2, s3 != 0, s4 != 0));
                }
                if (++currentElementIndex0 == length0) {
                    currentElementIndex0 = 0;
                }
                if (++currentElementIndex1 == length1) {
                    currentElementIndex1 = 0;
                }
                if (++currentElementIndex2 == length2) {
                    currentElementIndex2 = 0;
                }
                if (++currentElementIndex3 == length3) {
                    currentElementIndex3 = 0;
                }
                if (++currentElementIndex4 != length4) continue;
                currentElementIndex4 = 0;
            }
            if (length0 == cycles) {
                builder.combineStructuralAttributesFrom(vector0);
            }
            if (length1 == cycles) {
                builder.combineStructuralAttributesFrom(vector1);
            }
            if (length2 == cycles) {
                builder.combineStructuralAttributesFrom(vector2);
            }
            if (length3 == cycles) {
                builder.combineStructuralAttributesFrom(vector3);
            }
            if (length4 == cycles) {
                builder.combineStructuralAttributesFrom(vector4);
            }
            return builder.build();
        }
        throw new EvalException(String.format("Invalid argument:\n\tpnchisq(%s, %s, %s, %s, %s)\n\tExpected:\n\tpnchisq(double, double, double, logical, logical)", arg0.getTypeName(), arg1.getTypeName(), arg2.getTypeName(), arg3.getTypeName(), arg4.getTypeName()), new Object[0]);
    }
}

