/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.renjin.eval.Calls;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.DispatchChain;
import org.renjin.eval.EvalException;
import org.renjin.eval.Profiler;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.packaging.SerializedPromise;
import org.renjin.primitives.Attributes;
import org.renjin.primitives.Primitives;
import org.renjin.primitives.Types;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Closure;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.HashFrame;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.Promise;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class S3 {
    public static final Symbol METHODS_TABLE = Symbol.get(".__S3MethodsTable__.");
    public static final Set<String> GROUPS = Sets.newHashSet((Object[])new String[]{"Ops", "Math", "Summary"});
    private static final Set<String> ARITH_GROUP = Sets.newHashSet((Object[])new String[]{"+", "-", "*", "^", "%%", "%/%", "/"});
    private static final Set<String> COMPARE_GROUP = Sets.newHashSet((Object[])new String[]{"==", ">", "<", "!=", "<=", ">="});
    private static final Set<String> LOGIC_GROUP = Sets.newHashSet((Object[])new String[]{"&", "&&", "|", "||", "xor"});
    private static final Set<String> SPECIAL = Sets.newHashSet((Object[])new String[]{"$", "$<-"});

    @Builtin
    public static SEXP UseMethod(@Current Context context, String genericMethodName) {
        if (context.getArguments().length() == 0) {
            return S3.UseMethod(context, genericMethodName, Null.INSTANCE);
        }
        SEXP object2 = context.evaluate((SEXP)context.getArguments().getElementAsSEXP(0), context.getParent().getEnvironment());
        return S3.UseMethod(context, genericMethodName, object2);
    }

    @Builtin
    public static SEXP UseMethod(@Current Context context, String genericMethodName, SEXP object2) {
        return Resolver.start(context, genericMethodName, object2).withDefinitionEnvironment(context.getClosure().getEnclosingEnvironment()).next().apply(context, context.getEnvironment());
    }

    @Internal
    public static SEXP NextMethod(@Current Context context, @Current Environment env2, SEXP generic, SEXP object2, @ArgumentList ListVector extraArgs) {
        return Resolver.resume(context).withGenericArgument(generic).withObjectArgument(object2).next().applyNext(context, context.getEnvironment(), extraArgs);
    }

    public static StringVector computeDataClasses(Context context, SEXP exp2) {
        SEXP classAttribute = (exp2 = exp2.force(context)).getAttribute(Symbols.CLASS);
        if (classAttribute.length() > 0) {
            return (StringVector)classAttribute;
        }
        StringVector.Builder dataClass = new StringVector.Builder();
        SEXP dim2 = exp2.getAttribute(Symbols.DIM);
        if (dim2.length() == 2) {
            dataClass.add("matrix");
        } else if (dim2.length() == 1) {
            dataClass.add("array");
        }
        if (exp2 instanceof IntVector || exp2 instanceof DoubleVector) {
            dataClass.add(exp2.getTypeName());
            dataClass.add("numeric");
        } else {
            dataClass.add(exp2.getImplicitClass());
        }
        return dataClass.build();
    }

    public static SEXP dispatchGroup(String group, FunctionCall call2, String opName, PairList args2, Context context, Environment rho) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        boolean isOps = group.equals("Ops");
        int nargs2 = isOps ? args2.length() : 1;
        if (Types.isS4(args2.getElementAsSEXP(0))) {
            return S3.handleS4object(context, args2.getElementAsSEXP(0), args2, rho, group, opName);
        }
        GenericMethod left = Resolver.start(context, group, opName, args2.getElementAsSEXP(0)).withBaseDefinitionEnvironment().findNext();
        GenericMethod right = null;
        if (nargs2 == 2) {
            right = Resolver.start(context, group, opName, args2.getElementAsSEXP(1)).withBaseDefinitionEnvironment().findNext();
        }
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            left = right;
        }
        String[] m = new String[nargs2];
        for (int i = 0; i < nargs2; ++i) {
            StringVector t2 = S3.computeDataClasses(context, args2.getElementAsSEXP(i));
            boolean set2 = false;
            for (int j = 0; j < t2.length(); ++j) {
                if (!t2.getElementAsString(j).equals(left.className)) continue;
                m[i] = left.method.getPrintName();
                set2 = true;
                break;
            }
            if (set2) continue;
            m[i] = "";
        }
        left.withMethodVector(m);
        PairList promisedArgs = Calls.promiseArgs(call2.getArguments(), context, rho);
        if (promisedArgs.length() != args2.length()) {
            throw new EvalException("dispatch error in group dispatch", new Object[0]);
        }
        if (promisedArgs != Null.INSTANCE) {
            PairList.Node promised = (PairList.Node)promisedArgs;
            PairList.Node evaluated = (PairList.Node)args2;
            while (true) {
                ((Promise)promised.getValue()).setResult(evaluated.getValue());
                if (isOps) {
                    promised.setTag(Null.INSTANCE);
                }
                if (!promised.hasNextNode()) break;
                promised = promised.getNextNode();
                evaluated = evaluated.getNextNode();
            }
        }
        return left.doApply(context, rho, promisedArgs);
    }

    public static SEXP tryDispatchFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP object2, PairList args2) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        SEXP resultS4Dispatch = null;
        if (Types.isS4(object2) && S3.isS4DispatchSupported(name)) {
            resultS4Dispatch = S3.handleS4object(context, object2, args2, rho, null, name);
        }
        if (resultS4Dispatch != null) {
            return resultS4Dispatch;
        }
        GenericMethod method = Resolver.start(context, name, object2).withBaseDefinitionEnvironment().withObjectArgument(object2).withGenericArgument(name).findNext();
        if (method == null) {
            return null;
        }
        PairList newArgs = S3.reassembleAndEvaluateArgs(object2, args2, context, rho);
        return method.doApply(context, rho, newArgs);
    }

    private static boolean isS4DispatchSupported(String name) {
        return !"@<-".equals(name);
    }

    private static SEXP handleS4object(@Current Context context, SEXP source, PairList args2, Environment rho, String group, String opName) {
        boolean hasS3Class = source.getAttribute(Symbol.get(".S3Class")).length() != 0;
        String packageName = hasS3Class ? "methods" : null;
        Environment groupMethodEnvironment = null;
        Environment genericMethodEnvironment = null;
        genericMethodEnvironment = S3.findMethodEnvironment(context, opName, packageName);
        groupMethodEnvironment = "Ops".equals(group) ? S3.findOpsMethodEnvironment(context, opName, packageName) : S3.findMethodEnvironment(context, group, packageName);
        if (groupMethodEnvironment == null && genericMethodEnvironment == null) {
            return null;
        }
        int signatureLength = S3.computeSignatureLength(genericMethodEnvironment, groupMethodEnvironment);
        if (signatureLength == 0) {
            return null;
        }
        List<MethodRanking> possibleSignatures = S3.generatePossibleSignatures(context, rho, args2, signatureLength);
        Collections.sort(possibleSignatures);
        List<SelectedMethod> selectedMethods = S3.findMatchingMethods(context, genericMethodEnvironment, groupMethodEnvironment, possibleSignatures);
        if (selectedMethods.size() == 0) {
            return null;
        }
        SelectedMethod method = selectedMethods.get(0);
        if ("generic".equals(method.getGroup()) && method.getDistance() == 0 || hasS3Class) {
            return context.evaluate(new FunctionCall(method.getFunction(), args2));
        }
        SEXP variableDotDefined = S3.buildDotTargetOrDefined(context, method, true);
        SEXP variableDotTarget = S3.buildDotTargetOrDefined(context, method, false);
        SEXP variableDotGeneric = S3.buildDotGeneric(opName);
        HashMap<Symbol, SEXP> metadata = new HashMap<Symbol, SEXP>();
        metadata.put(Symbol.get(".defined"), variableDotDefined);
        metadata.put(Symbol.get(".Generic"), variableDotGeneric);
        metadata.put(Symbol.get(".Method"), method.getFunction());
        metadata.put(Symbol.get(".Methods"), Symbol.get(".Primitive(\"" + opName + "\")"));
        metadata.put(Symbol.get(".target"), variableDotTarget);
        return ClosureDispatcher.apply(context, rho, new FunctionCall(method.getFunction(), args2), method.getFunction(), args2, metadata);
    }

    private static SEXP buildDotGeneric(String opName) {
        StringVector generic = StringVector.valueOf(opName);
        generic.setAttribute("package", (SEXP)StringVector.valueOf("base"));
        return generic;
    }

    private static SEXP buildDotTargetOrDefined(Context context, SelectedMethod method, boolean defined) {
        List<String> argumentClasses = Arrays.asList(method.getSignature().split("#"));
        ArrayList<String> argumentPackages = new ArrayList<String>();
        if (defined) {
            for (String argumentClass : argumentClasses) {
                argumentPackages.add(S3.findClassPackage(context, argumentClass));
            }
        } else {
            for (String ignored : argumentClasses) {
                argumentPackages.add("methods");
            }
        }
        return new StringVector.Builder().addAll(argumentClasses).setAttribute("names", (SEXP)method.getFunction().getFormals().getNames()).setAttribute("package", (SEXP)new StringArrayVector((Collection<String>)argumentPackages)).setAttribute("class", S3.classWithPackage("signature", "methods")).build();
    }

    private static SEXP classWithPackage(String className, String packageName) {
        return StringVector.valueOf(className).setAttribute("package", (SEXP)StringVector.valueOf(packageName));
    }

    private static String findClassPackage(Context context, String className) {
        Environment environment2 = context.getGlobalEnvironment();
        SEXP classS4Object = environment2.findVariable(context, Symbol.get(".__C__" + className));
        if (classS4Object instanceof SerializedPromise || "ANY".equals(className)) {
            return "methods";
        }
        return classS4Object.getAttribute(Symbol.get("package")).asString();
    }

    private static Environment findMethodEnvironment(Context context, String opName, String packageName) {
        Symbol methodSymbol;
        Environment environment2 = packageName == null ? context.getGlobalEnvironment() : context.getNamespaceRegistry().getNamespace(context, packageName).getNamespaceEnvironment();
        SEXP genericMethodSymbol = environment2.findVariable(context, methodSymbol = Symbol.get(".__T__" + opName + ":base"));
        if (genericMethodSymbol instanceof Environment) {
            return (Environment)genericMethodSymbol;
        }
        if (SPECIAL.contains(opName)) {
            Namespace methodsNamespace = context.getNamespaceRegistry().getNamespace(context, "methods");
            genericMethodSymbol = methodsNamespace.getNamespaceEnvironment().findVariable(context, methodSymbol).force(context);
        }
        return genericMethodSymbol instanceof Environment ? (Environment)genericMethodSymbol : null;
    }

    private static int computeSignatureLength(Environment genericMethodEnvironment, Environment groupMethodEnvironment) {
        Environment methodEnvironment;
        Environment environment2 = methodEnvironment = genericMethodEnvironment == null ? groupMethodEnvironment : genericMethodEnvironment;
        if (methodEnvironment.getFrame().getSymbols().iterator().hasNext()) {
            return methodEnvironment.getFrame().getSymbols().iterator().next().getPrintName().split("#").length;
        }
        return 0;
    }

    private static List<SelectedMethod> findMatchingMethods(Context context, Environment methodEnvironment, Environment groupEnvironment, List<MethodRanking> possibleSignatures) {
        ArrayList<SelectedMethod> selectedMethods = new ArrayList<SelectedMethod>();
        String inputSignature = possibleSignatures.get(0).getSignature();
        for (MethodRanking possibleSignature : possibleSignatures) {
            SEXP function2 = Symbol.UNBOUND_VALUE;
            String source = "generic";
            String signature = possibleSignature.getSignature();
            int distance = possibleSignature.getTotalDist();
            Symbol signatureSymbol = Symbol.get(signature);
            if (methodEnvironment != null) {
                function2 = methodEnvironment.getFrame().getVariable(signatureSymbol).force(context);
            }
            if (function2 == Symbol.UNBOUND_VALUE && groupEnvironment != null) {
                source = "group";
                function2 = groupEnvironment.getFrame().getVariable(signatureSymbol).force(context);
            }
            if (!(function2 instanceof Closure)) continue;
            selectedMethods.add(new SelectedMethod((Closure)function2, source, distance, signature, signatureSymbol, inputSignature));
        }
        return selectedMethods;
    }

    private static Environment findOpsMethodEnvironment(Context context, String opName, String packageName) {
        Environment methodEnvironment = null;
        if (ARITH_GROUP.contains(opName)) {
            String[] groups = new String[]{".__T__Arith:base", ".__T__Ops:base"};
            methodEnvironment = S3.getEnvironment(context, null, groups, packageName);
        } else if (COMPARE_GROUP.contains(opName)) {
            String[] groups = new String[]{".__T__Compare:methods", ".__T__Ops:base"};
            methodEnvironment = S3.getEnvironment(context, null, groups, packageName);
        } else if (LOGIC_GROUP.contains(opName)) {
            String[] groups = new String[]{".__T__Logic:base", ".__T__Ops:base"};
            methodEnvironment = S3.getEnvironment(context, null, groups, packageName);
        }
        if (methodEnvironment == null) {
            throw new EvalException("No S4 method found for '" + opName + "'", new Object[0]);
        }
        return methodEnvironment;
    }

    private static Environment getEnvironment(Context context, Environment methodEnvironment, String[] groups, String packageName) {
        for (int i = 0; i < groups.length && methodEnvironment == null; ++i) {
            Environment environment2 = packageName == null ? context.getGlobalEnvironment() : context.getNamespaceRegistry().getNamespace(context, packageName).getNamespaceEnvironment();
            SEXP foundMethodEnvironment = environment2.findVariable(context, Symbol.get(groups[i]));
            methodEnvironment = foundMethodEnvironment instanceof Environment ? (Environment)foundMethodEnvironment : null;
        }
        return methodEnvironment;
    }

    private static List<MethodRanking> generatePossibleSignatures(Context context, Environment rho, PairList args2, int depth) {
        ArgumentSignature[] argSignatures = new ArgumentSignature[depth];
        for (int i = 0; i < depth; ++i) {
            String argumentClass = S3.evaluateAndGetClass(context, args2, rho, i);
            argSignatures[i] = S3.getClassAndDistance(context, argumentClass);
        }
        int numberOfPossibleSignatures = 1;
        for (int i = 0; i < argSignatures.length; ++i) {
            numberOfPossibleSignatures *= argSignatures[i].getArgument().length;
        }
        ArrayList<MethodRanking> possibleSignatures = new ArrayList<MethodRanking>(numberOfPossibleSignatures);
        int argumentClassIdx = 0;
        int repeat = 1;
        int repeatIdx = 1;
        for (int col2 = 0; col2 < depth; ++col2) {
            int numberOfClassesCurrentArgument = argSignatures[col2].getArgument().length;
            int row2 = 0;
            while (row2 < numberOfPossibleSignatures) {
                if (argumentClassIdx == numberOfClassesCurrentArgument) {
                    argumentClassIdx = 0;
                }
                ArgumentSignature argSignature = argSignatures[col2];
                String signature = argSignature.getArgument(argumentClassIdx);
                if (possibleSignatures.isEmpty() || possibleSignatures.toArray().length < row2 + 1 || possibleSignatures.toArray()[row2] == null) {
                    int[] distance = argSignature.getDistanceAsArray(argumentClassIdx);
                    possibleSignatures.add(row2, new MethodRanking(signature, distance));
                } else {
                    int distance = argSignature.getDistance(argumentClassIdx);
                    possibleSignatures.set(row2, ((MethodRanking)possibleSignatures.get(row2)).append(signature, distance));
                }
                if (repeat == 1) {
                    ++argumentClassIdx;
                }
                if (repeat != 1 && repeatIdx == repeat) {
                    repeatIdx = 0;
                    ++argumentClassIdx;
                }
                ++row2;
                ++repeatIdx;
            }
            repeatIdx = 1;
            argumentClassIdx = 0;
            repeat *= numberOfClassesCurrentArgument;
        }
        return possibleSignatures;
    }

    private static String evaluateAndGetClass(Context context, PairList args2, Environment rho, int argumentIndex) {
        SEXP evaluatedArg = context.evaluate((SEXP)args2.getElementAsSEXP(argumentIndex), rho);
        return Attributes.getClass(evaluatedArg).getElementAsString(0);
    }

    private static ArgumentSignature getClassAndDistance(Context context, String argClass) {
        Symbol argClassObjectName = Symbol.get(".__C__" + argClass);
        Frame globalFrame = context.getGlobalEnvironment().getFrame();
        AttributeMap map = globalFrame.getVariable(argClassObjectName).getAttributes();
        SEXP containsSlot = map.get("contains");
        AtomicVector argSuperClasses = containsSlot.getNames();
        int[] distances = new int[argSuperClasses.length() + 2];
        String[] classes = new String[argSuperClasses.length() + 2];
        classes[0] = argClass;
        distances[0] = 0;
        for (int i = 0; i < argSuperClasses.length(); ++i) {
            SEXP distanceSlot = ((ListVector)containsSlot).get(i).getAttributes().get("distance");
            distances[i + 1] = ((Vector)distanceSlot).getElementAsInt(0);
            classes[i + 1] = ((Vector)argSuperClasses).getElementAsString(i);
        }
        int max2 = 0;
        for (int i = 0; i < distances.length; ++i) {
            if (distances[i] <= max2) continue;
            max2 = distances[i];
        }
        distances[argSuperClasses.length() + 1] = max2 + 1;
        classes[distances.length - 1] = "ANY";
        return new ArgumentSignature(classes, distances);
    }

    public static SEXP tryDispatchFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, String[] argumentNames, SEXP[] arguments) {
        if (call2.getFunction() instanceof Symbol && ((Symbol)call2.getFunction()).getPrintName().endsWith(".default")) {
            return null;
        }
        Vector classVector = (Vector)arguments[0].getAttribute(Symbols.CLASS);
        if (classVector.length() == 0) {
            return null;
        }
        DispatchChain chain = DispatchChain.newChain(context, rho, name, classVector);
        if (chain == null) {
            return null;
        }
        PairList.Builder newArgsBuilder = new PairList.Builder();
        for (int i = 0; i != arguments.length; ++i) {
            newArgsBuilder.add(argumentNames[i], arguments[i]);
        }
        PairList newArgs = newArgsBuilder.build();
        FunctionCall newCall = new FunctionCall(chain.getMethodSymbol(), newArgs);
        ClosureDispatcher dispatcher = new ClosureDispatcher(context, rho, newCall);
        return dispatcher.apply(chain, newArgs);
    }

    static PairList reassembleAndEvaluateArgs(SEXP object2, PairList args2, Context context, Environment rho) {
        PairList.Builder newArgs = new PairList.Builder();
        PairList.Node firstArg = (PairList.Node)args2;
        newArgs.add(firstArg.getRawTag(), object2);
        ArgumentIterator argIt = new ArgumentIterator(context, rho, firstArg.getNext());
        while (argIt.hasNext()) {
            PairList.Node node = argIt.nextNode();
            newArgs.add(node.getRawTag(), context.evaluate(node.getValue(), rho));
        }
        return newArgs.build();
    }

    public static SEXP tryDispatchOpsFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP s0) {
        PairList.Node newArgs = new PairList.Node(s0, Null.INSTANCE);
        return S3.dispatchGroup("Ops", call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchOpsFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, SEXP s0, SEXP s1) {
        PairList.Node newArgs = new PairList.Node(s0, new PairList.Node(s1, Null.INSTANCE));
        return S3.dispatchGroup("Ops", call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchGroupFromPrimitive(Context context, Environment rho, FunctionCall call2, String group, String name, SEXP s0, PairList args2) {
        PairList.Node firstNode = (PairList.Node)args2;
        PairList.Node newArgs = new PairList.Node(s0, firstNode.getNext());
        return S3.dispatchGroup(group, call2, name, newArgs, context, rho);
    }

    public static SEXP tryDispatchSummaryFromPrimitive(Context context, Environment rho, FunctionCall call2, String name, ListVector evaluatedArguments, boolean naRm) {
        PairList.Builder newArgs = new PairList.Builder();
        int varArgIndex = 0;
        Symbol naRmName = Symbol.get("na.rm");
        for (PairList.Node node : call2.getArguments().nodes()) {
            if (node.getRawTag() == naRmName) {
                newArgs.add(node.getTag(), (SEXP)new LogicalArrayVector(naRm));
                continue;
            }
            newArgs.add(node.getRawTag(), evaluatedArguments.get(varArgIndex++));
        }
        return S3.dispatchGroup("Summary", call2, name, newArgs.build(), context, rho);
    }

    public static PairList updateArguments(Context context, PairList actuals, PairList formals2, Environment previousEnv, ListVector extraArgs) {
        ArrayList actualNames = Lists.newArrayList();
        ArrayList actualValues = Lists.newArrayList();
        ArrayList matchedNames = Lists.newArrayList();
        LinkedList unmatchedFormals = Lists.newLinkedList(formals2.nodes());
        for (PairList.Node node : actuals.nodes()) {
            if (node.getValue() instanceof PromisePairList) {
                PromisePairList ellipses = (PromisePairList)node.getValue();
                for (PairList.Node nestedNode : ellipses.nodes()) {
                    actualNames.add(nestedNode.getRawTag());
                    actualValues.add(nestedNode.getValue());
                    matchedNames.add(S3.matchArgumentExactlyByName(nestedNode.getRawTag(), unmatchedFormals));
                }
                continue;
            }
            actualNames.add(node.getRawTag());
            actualValues.add(node.getValue());
            matchedNames.add(S3.matchArgumentExactlyByName(node.getRawTag(), unmatchedFormals));
        }
        for (int i = 0; i != matchedNames.size(); ++i) {
            if (matchedNames.get(i) != null) continue;
            matchedNames.set(i, S3.matchPartiallyByName((SEXP)actualNames.get(i), unmatchedFormals));
        }
        Iterator formalIt = unmatchedFormals.iterator();
        for (int i = 0; i != matchedNames.size(); ++i) {
            if (matchedNames.get(i) != null) continue;
            if (!formalIt.hasNext()) {
                throw new EvalException("Unmatched argument", new Object[0]);
            }
            Symbol nextFormalName = ((PairList.Node)formalIt.next()).getTag();
            if (nextFormalName == Symbols.ELLIPSES) break;
            matchedNames.set(i, nextFormalName);
        }
        PairList.Builder updated = PairList.Node.newBuilder();
        for (int i = 0; i != matchedNames.size(); ++i) {
            SEXP updatedValue;
            if (matchedNames.get(i) != null) {
                updatedValue = previousEnv.getVariableUnsafe((Symbol)matchedNames.get(i));
                assert (updatedValue != Symbol.UNBOUND_VALUE);
            } else {
                updatedValue = (SEXP)actualValues.get(i);
            }
            updated.add((SEXP)actualNames.get(i), updatedValue);
        }
        for (NamedValue extraArg : extraArgs.namedValues()) {
            if (!extraArg.hasName()) {
                updated.add(extraArg.getValue());
                continue;
            }
            updated.set(extraArg.getName(), extraArg.getValue());
        }
        return updated.build();
    }

    private static Symbol matchArgumentExactlyByName(SEXP tag, List<PairList.Node> unmatchedFormals) {
        if (tag == Null.INSTANCE) {
            return null;
        }
        for (PairList.Node formal : unmatchedFormals) {
            if (formal.getTag() != tag) continue;
            unmatchedFormals.remove(formal);
            return formal.getTag();
        }
        return null;
    }

    private static Symbol matchPartiallyByName(SEXP tag, List<PairList.Node> unmatchedFormals) {
        if (tag == Null.INSTANCE) {
            return null;
        }
        String name = ((Symbol)tag).getPrintName();
        PairList.Node partialMatch = null;
        for (PairList.Node formal : unmatchedFormals) {
            if (!formal.getTag().getPrintName().startsWith(name)) continue;
            if (partialMatch != null) {
                throw new EvalException("multiple partial matches", new Object[0]);
            }
            partialMatch = formal;
        }
        if (partialMatch == null) {
            return null;
        }
        return partialMatch.getTag();
    }

    public static class SelectedMethod {
        private Closure function;
        private String group;
        private int currentDistance;
        private String currentSig;
        private Symbol methodName;
        private String methodInputSignature;

        SelectedMethod(Closure fun, String grp, int dist, String sig, Symbol method, String methSig) {
            this.function = fun;
            this.group = grp;
            this.currentDistance = dist;
            this.currentSig = sig;
            this.methodName = method;
            this.methodInputSignature = methSig;
        }

        public Closure getFunction() {
            return this.function;
        }

        public String getGroup() {
            return this.group;
        }

        public int getDistance() {
            return this.currentDistance;
        }

        public String getSignature() {
            return this.currentSig;
        }

        public Symbol getMethod() {
            return this.methodName;
        }

        public String getInputSignature() {
            return this.methodInputSignature;
        }
    }

    public static class MethodRanking
    implements Comparable<MethodRanking> {
        private String signature;
        private int[] distances;
        private boolean has0 = false;
        private int totalDist = 0;
        private double rank = 0.0;

        MethodRanking(String signature, int[] distance) {
            this.signature = signature;
            this.distances = distance;
            int totalDistance = 0;
            for (int i = 0; i < distance.length; ++i) {
                this.rank += 10007.0 * Math.pow(0.5, i) * (double)distance[i];
                if (distance[i] == 0) {
                    this.has0 = true;
                    continue;
                }
                totalDistance += distance[i];
            }
            this.totalDist = totalDistance;
        }

        public MethodRanking append(String argument, int distance) {
            String newSig = this.signature + "#" + argument;
            int[] newDist = new int[this.distances.length + 1];
            for (int i = 0; i < this.distances.length; ++i) {
                newDist[i] = this.distances[i];
            }
            newDist[this.distances.length] = distance;
            this.signature = newSig;
            this.distances = newDist;
            this.has0 = this.has0 || distance == 0;
            this.totalDist += distance;
            this.rank += 10007.0 * Math.pow(0.5, newDist.length) * (double)distance;
            return this;
        }

        public String getSignature() {
            return this.signature;
        }

        public int[] getDistance() {
            return this.distances;
        }

        public int getTotalDist() {
            return this.totalDist;
        }

        public int isHas0() {
            if (this.has0) {
                return 0;
            }
            return 1;
        }

        public double getRank() {
            return this.rank;
        }

        @Override
        public int compareTo(MethodRanking o) {
            int i = Integer.compare(this.getTotalDist(), o.getTotalDist());
            if (i != 0) {
                return i;
            }
            i = Integer.compare(this.isHas0(), o.isHas0());
            if (i != 0) {
                return i;
            }
            return Double.compare(this.rank, o.getRank());
        }
    }

    public static class ArgumentSignature {
        private String[] argumentClasses;
        private int[] distances;

        ArgumentSignature(String[] classes, int[] distances) {
            this.argumentClasses = classes;
            this.distances = distances;
        }

        public String[] getArgument() {
            return this.argumentClasses;
        }

        public String getArgument(int position) {
            return this.argumentClasses[position];
        }

        public int getDistance(int position) {
            return this.distances[position];
        }

        public int[] getDistanceAsArray(int position) {
            int[] array2 = new int[]{this.distances[position]};
            return array2;
        }
    }

    public static class GenericMethod {
        private Resolver resolver;
        private Symbol method;
        private Function function;
        private String className;
        private StringVector methodVector;

        public GenericMethod(Resolver resolver, Symbol method, String className, Function function2) {
            assert (function2 != null);
            this.resolver = resolver;
            this.method = method;
            this.methodVector = new StringArrayVector(method.getPrintName());
            this.className = className;
            this.function = function2;
        }

        public SEXP apply(Context callContext, Environment callEnvironment) {
            PairList rePromisedArgs = Calls.promiseArgs(callContext.getArguments(), callContext, callEnvironment);
            return this.doApply(callContext, callEnvironment, rePromisedArgs);
        }

        public SEXP applyNext(Context context, Environment environment2, ListVector extraArgs) {
            PairList arguments = this.nextArguments(context, extraArgs);
            if ("Ops".equals(this.resolver.group) && arguments.length() == 2) {
                this.withMethodVector(this.groupsMethodVector());
            }
            return this.doApply(context, environment2, arguments);
        }

        private String[] groupsMethodVector() {
            GenericMethod previousMethod = this.resolver.previousContext.getState(GenericMethod.class);
            String[] methodVector = previousMethod.methodVector.toArray();
            String methodName = this.methodVector.getElementAsString(0);
            for (int i = 0; i < methodVector.length; ++i) {
                if (methodVector[i].equals("")) continue;
                methodVector[i] = methodName;
            }
            return methodVector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SEXP doApply(Context callContext, Environment callEnvironment, PairList args2) {
            FunctionCall newCall = new FunctionCall(this.method, args2);
            callContext.setState(GenericMethod.class, this);
            if (Profiler.ENABLED) {
                Profiler.functionStart(this.method, this.function);
            }
            try {
                if (this.function instanceof Closure) {
                    Environment callingEnvironment = callContext.getCallingEnvironment();
                    if (callingEnvironment == null) {
                        callingEnvironment = callContext.getGlobalEnvironment();
                    }
                    SEXP sEXP = Calls.applyClosure((Closure)this.function, callContext, callingEnvironment, newCall, args2, this.persistChain());
                    return sEXP;
                }
                SEXP sEXP = this.function.apply(callContext, callEnvironment, newCall, args2);
                return sEXP;
            }
            finally {
                callContext.clearState(GenericMethod.class);
                if (Profiler.ENABLED) {
                    Profiler.functionEnd();
                }
            }
        }

        public GenericMethod withMethodVector(String[] methodNames) {
            this.methodVector = new StringArrayVector(methodNames);
            return this;
        }

        public PairList nextArguments(Context callContext, ListVector extraArgs) {
            Context parentContext = callContext.getParent();
            while (parentContext.getParent() != this.resolver.previousContext) {
                parentContext = parentContext.getParent();
            }
            PairList actuals = parentContext.getArguments();
            Closure closure = parentContext.getClosure();
            PairList formals2 = closure.getFormals();
            Environment previousEnv = parentContext.getEnvironment();
            return S3.updateArguments(parentContext, actuals, formals2, previousEnv, extraArgs);
        }

        private Frame persistChain() {
            HashFrame frame2 = new HashFrame();
            frame2.setVariable(Symbol.get(".Class"), new StringArrayVector(this.resolver.classes));
            frame2.setVariable(Symbol.get(".Method"), this.methodVector);
            frame2.setVariable(Symbol.get(".Generic"), StringVector.valueOf(this.resolver.genericMethodName));
            frame2.setVariable(Symbol.get(".GenericCallEnv"), this.resolver.callingEnvironment);
            frame2.setVariable(Symbol.get(".GenericDefEnv"), this.resolver.definitionEnvironment);
            return frame2;
        }

        public String toString() {
            return this.method + "." + this.className;
        }

        public List<String> nextClasses() {
            if (this.className == null) {
                return Collections.emptyList();
            }
            int myIndex = this.resolver.classes.indexOf(this.className);
            return this.resolver.classes.subList(myIndex + 1, this.resolver.classes.size());
        }
    }

    private static class Resolver {
        private Environment callingEnvironment;
        private Environment definitionEnvironment = Environment.EMPTY;
        private String group;
        private String genericMethodName;
        private List<String> classes;
        private Context context;
        private SEXP object;
        private Context previousContext;

        private Resolver() {
        }

        private static Resolver start(Context context, String genericMethodName, SEXP object2) {
            return Resolver.start(context, null, genericMethodName, object2);
        }

        private static Resolver start(Context context, String group, String genericMethodName, SEXP object2) {
            Resolver resolver = new Resolver();
            resolver.callingEnvironment = context.getEnvironment();
            resolver.genericMethodName = genericMethodName;
            resolver.context = context;
            resolver.object = object2;
            resolver.group = group;
            resolver.classes = Lists.newArrayList((Iterable)S3.computeDataClasses(context, object2));
            return resolver;
        }

        public static Resolver resume(Context context) {
            Context parentContext = Resolver.findParentContext(context);
            GenericMethod method = parentContext.getState(GenericMethod.class);
            Resolver resolver = new Resolver();
            resolver.context = context;
            resolver.previousContext = parentContext;
            resolver.callingEnvironment = context.getEnvironment();
            resolver.definitionEnvironment = ((GenericMethod)method).resolver.definitionEnvironment;
            resolver.genericMethodName = ((GenericMethod)method).resolver.genericMethodName;
            resolver.classes = method.nextClasses();
            resolver.group = ((GenericMethod)method).resolver.group;
            resolver.object = ((GenericMethod)method).resolver.object;
            return resolver;
        }

        public Resolver withObjectArgument(SEXP object2) {
            if (object2 != Null.INSTANCE) {
                this.object = object2;
            }
            return this;
        }

        public Resolver withGenericArgument(SEXP generic) {
            if (generic != Null.INSTANCE) {
                this.genericMethodName = generic.asString();
            }
            return this;
        }

        public Resolver withGenericArgument(String genericName) {
            this.genericMethodName = genericName;
            return this;
        }

        public Resolver withDefinitionEnvironment(Environment rho) {
            this.definitionEnvironment = rho;
            return this;
        }

        public Resolver withBaseDefinitionEnvironment() {
            this.definitionEnvironment = this.context.getBaseEnvironment();
            return this;
        }

        private static Context findParentContext(Context context) {
            while (context != null) {
                if (context.getState(GenericMethod.class) != null) {
                    return context;
                }
                context = context.getParent();
            }
            throw new EvalException("NextMethod called out of context", new Object[0]);
        }

        public GenericMethod next() {
            GenericMethod next = this.findNextOrDefault();
            if (next == null) {
                throw new EvalException("no applicable method for '%s' applied to an object of class \"%s\"", this.genericMethodName, this.classes.toString());
            }
            return next;
        }

        private GenericMethod findNextOrDefault() {
            GenericMethod next = this.findNext();
            if (next != null) {
                return next;
            }
            Environment methodTable = this.getMethodTable();
            GenericMethod function2 = this.findNext(methodTable, this.genericMethodName, "default");
            if (function2 != null) {
                return function2;
            }
            PrimitiveFunction primitive2 = Primitives.getBuiltin(this.genericMethodName);
            if (primitive2 != null) {
                return new GenericMethod(this, Symbol.get(this.genericMethodName + ".default"), null, primitive2);
            }
            return null;
        }

        public GenericMethod findNext() {
            Environment methodTable = this.getMethodTable();
            for (String className : this.classes) {
                GenericMethod method = this.findNext(methodTable, this.genericMethodName, className);
                if (method != null) {
                    return method;
                }
                if (this.group == null || (method = this.findNext(methodTable, this.group, className)) == null) continue;
                return method;
            }
            return null;
        }

        private GenericMethod findNext(Environment methodTable, String name, String className) {
            Symbol method = Symbol.get(name + "." + className);
            Function function2 = this.callingEnvironment.findFunction(this.context, method);
            if (function2 != null) {
                return new GenericMethod(this, method, className, function2);
            }
            if (methodTable != null && methodTable.hasVariable(method)) {
                return new GenericMethod(this, method, className, (Function)methodTable.getVariableUnsafe(method).force(this.context));
            }
            return null;
        }

        private Environment getMethodTable() {
            SEXP table = this.definitionEnvironment.getVariableUnsafe(METHODS_TABLE).force(this.context);
            if (table instanceof Environment) {
                return (Environment)table;
            }
            if (table == Symbol.UNBOUND_VALUE) {
                return null;
            }
            throw new EvalException("Unexpected value for .__S3MethodsTable__. in " + this.definitionEnvironment.getName(), new Object[0]);
        }
    }
}

