/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.HashMap;
import org.renjin.invoke.annotations.Internal;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Split {
    private Split() {
    }

    @Internal
    public static ListVector split(Vector toSplit, IntVector factors) {
        HashMap map = Maps.newHashMap();
        int length2 = Math.max(toSplit.length(), factors.length());
        for (int i = 0; i != length2; ++i) {
            int factorIndex = i % factors.length();
            int splitIndex = factors.getElementAsInt(factorIndex);
            if (IntVector.isNA(splitIndex)) continue;
            SplitBuilder splitBuilder = (SplitBuilder)map.get(splitIndex);
            if (splitBuilder == null) {
                splitBuilder = new SplitBuilder(toSplit);
                map.put(splitIndex, splitBuilder);
            }
            splitBuilder.add(toSplit, i);
        }
        StringVector levels2 = (StringVector)factors.getAttributes().get(Symbols.LEVELS);
        ListVector.NamedBuilder resultList = new ListVector.NamedBuilder();
        for (Integer split2 : map.keySet()) {
            resultList.add(levels2.getElementAsString(split2 - 1), (SEXP)((SplitBuilder)map.get(split2)).build());
        }
        return resultList.build();
    }

    private static class SplitBuilder {
        private Vector.Builder source;
        private AtomicVector sourceNames;
        private StringVector.Builder names;

        public SplitBuilder(Vector toSplit) {
            this.source = toSplit.newBuilderWithInitialCapacity(0);
            this.sourceNames = toSplit.getNames();
            if (this.sourceNames != Null.INSTANCE) {
                this.names = new StringVector.Builder();
            }
        }

        public void add(Vector source, int sourceIndex) {
            if (sourceIndex < source.length()) {
                this.source.addFrom(source, sourceIndex);
                if (this.names != null) {
                    this.names.add(this.sourceNames.getElementAsString(sourceIndex));
                }
            }
        }

        public Vector build() {
            if (this.names != null) {
                this.source.setAttribute(Symbols.NAMES, (SEXP)this.names.build());
            }
            return this.source.build();
        }
    }
}

