/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import java.util.List;
import org.renjin.eval.Context;
import org.renjin.primitives.combine.AbstractBindFunction;
import org.renjin.primitives.combine.BindArgument;
import org.renjin.primitives.combine.Matrix2dBuilder;
import org.renjin.primitives.combine.MatrixDim;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class ColumnBindFunction
extends AbstractBindFunction {
    public ColumnBindFunction() {
        super("cbind", MatrixDim.COL);
    }

    @Override
    public SEXP apply(Context context, List<BindArgument> bindArguments) {
        int rows = this.computeRowCount(bindArguments, context);
        if (rows > 0) {
            bindArguments = this.excludeZeroLengthVectors(bindArguments);
        }
        int columns = this.countRowOrCols(bindArguments, MatrixDim.COL);
        Vector.Builder vectorBuilder = this.builderForCommonType(bindArguments);
        Matrix2dBuilder builder = new Matrix2dBuilder(vectorBuilder, rows, columns);
        for (BindArgument argument : bindArguments) {
            if (argument.isZeroLength()) continue;
            for (int j = 0; j != argument.getCols(); ++j) {
                for (int i = 0; i != rows; ++i) {
                    builder.addFrom(argument, i, j);
                }
            }
        }
        AtomicVector rowNames = this.dimNamesFromLongest(bindArguments, MatrixDim.ROW, rows);
        AtomicVector colNames = this.combineDimNames(bindArguments, MatrixDim.COL);
        if (ColumnBindFunction.allZeroLengthVectors(bindArguments)) {
            builder.setDimNames(Null.INSTANCE, Null.INSTANCE);
        } else if (rowNames != Null.INSTANCE || colNames != Null.INSTANCE) {
            builder.setDimNames(rowNames, colNames);
        }
        return builder.build();
    }

    private int computeRowCount(List<BindArgument> bindArguments, Context context) {
        int rows = this.findCommonMatrixDimLength(bindArguments, MatrixDim.ROW);
        if (rows == -1) {
            rows = ColumnBindFunction.findMaxLength(bindArguments);
        }
        this.warnIfVectorLengthsAreNotMultiple(context, bindArguments, rows);
        return rows;
    }
}

