/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import java.util.List;
import org.renjin.eval.Context;
import org.renjin.primitives.combine.AbstractBindFunction;
import org.renjin.primitives.combine.BindArgument;
import org.renjin.primitives.combine.Matrix2dBuilder;
import org.renjin.primitives.combine.MatrixDim;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class RowBindFunction
extends AbstractBindFunction {
    public RowBindFunction() {
        super("rbind", MatrixDim.ROW);
    }

    @Override
    protected SEXP apply(Context context, List<BindArgument> bindArguments) {
        int columns = this.computeColumnCount(context, bindArguments);
        if (columns > 0) {
            bindArguments = this.excludeZeroLengthVectors(bindArguments);
        }
        int rows = this.countRowOrCols(bindArguments, MatrixDim.ROW);
        Vector.Builder vectorBuilder = this.builderForCommonType(bindArguments);
        Matrix2dBuilder builder = new Matrix2dBuilder(vectorBuilder, rows, columns);
        for (int j = 0; j != columns; ++j) {
            for (BindArgument argument : bindArguments) {
                for (int i = 0; i != argument.getRows(); ++i) {
                    builder.addFrom(argument, i, j);
                }
            }
        }
        AtomicVector rowNames = this.combineDimNames(bindArguments, MatrixDim.ROW);
        AtomicVector colNames = this.dimNamesFromLongest(bindArguments, MatrixDim.COL, columns);
        if (RowBindFunction.allZeroLengthVectors(bindArguments)) {
            builder.setDimNames(Null.INSTANCE, Null.INSTANCE);
        } else if (rowNames != Null.INSTANCE || colNames != Null.INSTANCE) {
            builder.setDimNames(rowNames, colNames);
        }
        return builder.build();
    }

    private int computeColumnCount(Context context, List<BindArgument> bindArguments) {
        int columns = this.findCommonMatrixDimLength(bindArguments, MatrixDim.COL);
        if (columns == -1) {
            columns = RowBindFunction.findMaxLength(bindArguments);
        }
        this.warnIfVectorLengthsAreNotMultiple(context, bindArguments, columns);
        return columns;
    }
}

