/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.repackaged.guava.base.Charsets;

public abstract class AbstractConnection
implements Connection {
    private PushbackBufferedReader reader;
    private PrintWriter writer;
    private Charset charset;

    protected AbstractConnection(Charset charset) {
        this.charset = charset;
    }

    public AbstractConnection() {
        this(Charsets.UTF_8);
    }

    @Override
    public final PushbackBufferedReader getReader() throws IOException {
        if (this.reader == null) {
            this.reader = new PushbackBufferedReader(new InputStreamReader(this.getInputStream(), this.charset));
        }
        return this.reader;
    }

    @Override
    public final PrintWriter getPrintWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter(this.getOutputStream(), this.charset));
        }
        return this.writer;
    }

    @Override
    public PrintWriter getOpenPrintWriter() {
        if (this.writer == null) {
            throw new IllegalStateException();
        }
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        } else {
            this.closeInputIfOpen();
        }
        if (this.writer != null) {
            this.writer.close();
        } else {
            this.closeOutputIfOpen();
        }
    }

    @Override
    public String getMode() {
        return "r";
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    protected abstract void closeInputIfOpen() throws IOException;

    protected abstract void closeOutputIfOpen() throws IOException;
}

