/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import org.renjin.primitives.io.connections.Connection;
import org.renjin.repackaged.guava.base.Strings;

public class OpenSpec {
    private String spec;

    public OpenSpec(String spec) {
        this.spec = Strings.nullToEmpty((String)spec).toLowerCase();
    }

    public boolean forReading() {
        return this.spec.startsWith("r") || this.spec.equals("w+b");
    }

    public boolean forWriting() {
        return this.spec.equals("r+") || this.spec.contains("w") || this.spec.contains("a");
    }

    public boolean isAppend() {
        return this.spec.contains("a");
    }

    public boolean isText() {
        return !this.spec.contains("b");
    }

    public boolean isBinary() {
        return this.spec.contains("b");
    }

    public Connection.Type getType() {
        return this.isText() ? Connection.Type.TEXT : Connection.Type.BINARY;
    }

    public String toString() {
        return this.spec;
    }
}

