/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.renjin.repackaged.guava.base.Strings;

public class PushbackBufferedReader
extends Reader {
    private BufferedReader reader;
    private StringBuilder pushbackStack = new StringBuilder();

    public PushbackBufferedReader(Reader reader) {
        this.reader = new BufferedReader(reader);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.pushbackStack.length() == 0) {
            return this.reader.read(cbuf, off, len);
        }
        int toRead = Math.min(this.pushbackStack.length(), len);
        this.pushbackStack.getChars(0, toRead, cbuf, off);
        this.pushbackStack.delete(0, toRead);
        return toRead;
    }

    public void pushBack(String string) {
        this.pushbackStack.insert(0, string);
    }

    public String readLine() throws IOException {
        if (this.pushbackStack.length() == 0) {
            return this.reader.readLine();
        }
        int newLine = this.nextNewline(this.pushbackStack);
        if (newLine == -1) {
            return this.popStack() + Strings.nullToEmpty((String)this.reader.readLine());
        }
        return this.popStack(newLine);
    }

    private int nextNewline(StringBuilder stack) {
        for (int i = 0; i != stack.length(); ++i) {
            if (stack.charAt(i) != '\n') continue;
            return i;
        }
        return -1;
    }

    private String popStack() {
        String line = this.pushbackStack.toString();
        this.pushbackStack.setLength(0);
        return line;
    }

    private String popStack(int newLinePos) {
        int eol = newLinePos;
        if (newLinePos != 0 && this.pushbackStack.charAt(newLinePos - 1) == '\r') {
            --eol;
        }
        String line = this.pushbackStack.substring(0, eol);
        this.pushbackStack.delete(0, newLinePos + 1);
        return line;
    }

    public int countLinesPushedBack() {
        int count = 0;
        for (int i = 0; i != this.pushbackStack.length(); ++i) {
            if (this.pushbackStack.charAt(i) != '\n') continue;
            ++count;
        }
        if (count == 0 && this.pushbackStack.length() > 0) {
            return 1;
        }
        return count;
    }
}

