/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.match;

import java.util.HashMap;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.match.AnyDuplicateAlgorithm;
import org.renjin.primitives.match.DuplicateSearchAlgorithm;
import org.renjin.primitives.match.DuplicatedAlgorithm;
import org.renjin.primitives.match.IndexSequence;
import org.renjin.primitives.match.UniqueAlgorithm;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Vector;

public class Duplicates {
    @Internal
    public static Vector unique(Vector x, Vector incomparables, boolean fromLast) {
        return Duplicates.search(x, incomparables, fromLast, new UniqueAlgorithm());
    }

    @Internal
    public static Vector duplicated(Vector x, AtomicVector incomparables, boolean fromLast) {
        return Duplicates.search(x, incomparables, fromLast, new DuplicatedAlgorithm());
    }

    @Internal
    public static int anyDuplicated(Vector x, AtomicVector incomparables, boolean fromLast) {
        return Duplicates.search(x, incomparables, fromLast, new AnyDuplicateAlgorithm());
    }

    private static <ResultType> ResultType search(Vector x, Vector incomparables, boolean fromLast, DuplicateSearchAlgorithm<ResultType> algorithm) {
        algorithm.init(x);
        HashMap seen = Maps.newHashMap();
        for (Integer index : new IndexSequence(x, fromLast)) {
            Object element = x.getElementAsObject(index);
            Integer originalIndex = (Integer)seen.get(element);
            if (originalIndex == null) {
                algorithm.onUnique(index);
                seen.put(element, index);
                continue;
            }
            if (algorithm.onDuplicate(index, originalIndex) != DuplicateSearchAlgorithm.Action.STOP) continue;
            return algorithm.getResult();
        }
        return algorithm.getResult();
    }
}

