/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.renjin.primitives.packaging.FileBasedPackage;
import org.renjin.primitives.packaging.FqPackageName;
import org.renjin.repackaged.guava.io.Resources;
import org.renjin.util.NamedByteSource;

public class ClasspathPackage
extends FileBasedPackage {
    private ClassLoader classLoader;

    public ClasspathPackage(ClassLoader classLoader, FqPackageName name) {
        super(name);
        this.classLoader = classLoader;
    }

    public ClasspathPackage(FqPackageName name) {
        this(ClasspathPackage.class.getClassLoader(), name);
    }

    public boolean exists() {
        return this.resourceExists("environment");
    }

    @Override
    public NamedByteSource getResource(String name) throws IOException {
        String qualifiedName = this.qualifyResourceName(name);
        URL url2 = this.classLoader.getResource(qualifiedName);
        if (url2 == null) {
            throw new IOException(String.format("Could not find %s (%s)", name, qualifiedName));
        }
        try {
            return new NamedByteSource(name, Resources.asByteSource((URL)url2));
        }
        catch (Exception e) {
            throw new IOException(String.format("Could not load %s (%s)", name, url2.toString()), e);
        }
    }

    @Override
    public Class loadClass(String name) throws ClassNotFoundException {
        return this.classLoader.loadClass(name);
    }

    @Override
    public FileObject resolvePackageRoot(FileSystemManager fileSystemManager) throws FileSystemException {
        String qualifiedName = this.qualifyResourceName("environment");
        URL url2 = this.classLoader.getResource(qualifiedName);
        return fileSystemManager.resolveFile(url2.toString()).getParent();
    }

    private String qualifyResourceName(String name) {
        return this.getName().getGroupId().replace('.', '/') + "/" + this.getName().getPackageName() + "/" + name;
    }

    @Override
    public boolean resourceExists(String name) {
        URL url2 = this.classLoader.getResource(this.qualifyResourceName(name));
        return url2 != null;
    }
}

