/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.packaging;

import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.packaging.NamespaceRegistry;
import org.renjin.repackaged.guava.base.Optional;
import org.renjin.repackaged.guava.collect.ImmutableSet;
import org.renjin.sexp.Frame;
import org.renjin.sexp.Function;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class NamespaceFrame
implements Frame {
    private final NamespaceRegistry registry;

    public NamespaceFrame(NamespaceRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Set<Symbol> getSymbols() {
        return ImmutableSet.copyOf(this.registry.getLoadedNamespaces());
    }

    @Override
    public SEXP getVariable(Symbol name) {
        Optional<Namespace> namespace = this.registry.getNamespaceIfPresent(name);
        if (namespace.isPresent()) {
            return ((Namespace)namespace.get()).getNamespaceEnvironment();
        }
        return Symbol.UNBOUND_VALUE;
    }

    @Override
    public Function getFunction(Context context, Symbol name) {
        return null;
    }

    @Override
    public boolean isMissingArgument(Symbol name) {
        return false;
    }

    @Override
    public void setVariable(Symbol name, SEXP value) {
        throw new EvalException("Cannot modify the namespace registry", new Object[0]);
    }

    @Override
    public void clear() {
        throw new EvalException("Cannot modify the namespace registry", new Object[0]);
    }

    @Override
    public void remove(Symbol name) {
        throw new EvalException("Cannot modify the namespace registry", new Object[0]);
    }
}

