/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.EvalException;
import org.renjin.primitives.Indexes;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Vector;

class CoordinateMatrixIterator
implements IndexIterator {
    private AtomicVector coordinateMatrix;
    private int coordinateRows;
    private int coordinateColumns;
    private int[] sourceDim;
    private int nextRow = 0;
    private int[] coordRow;

    public CoordinateMatrixIterator(Vector source, AtomicVector coordinateMatrix) {
        this.coordinateMatrix = coordinateMatrix;
        this.sourceDim = source.getAttributes().getDimArray();
        int[] coordinateMatrixDims = coordinateMatrix.getAttributes().getDimArray();
        this.coordinateRows = coordinateMatrixDims[0];
        this.coordinateColumns = coordinateMatrixDims[1];
        this.coordRow = new int[this.sourceDim.length];
        assert (this.coordinateColumns == this.sourceDim.length) : "coordinate matrix shape does not match source array dimensions";
    }

    @Override
    public int next() {
        block0: while (true) {
            if (this.nextRow >= this.coordinateRows) {
                return -1;
            }
            ++this.nextRow;
            for (int i = 0; i != this.coordRow.length; ++i) {
                int coordRow;
                int coord = this.coordinateMatrix.getElementAsInt(Indexes.matrixIndexToVectorIndex(coordRow, i, this.coordinateRows, this.coordinateColumns));
                if (coord == 0) continue block0;
                if (IntVector.isNA(coord)) {
                    return Integer.MIN_VALUE;
                }
                if (coord < 0) {
                    throw new EvalException("negative values are not allowed in a matrix subscript", new Object[0]);
                }
                this.coordRow[i] = coord - 1;
            }
            break;
        }
        return Indexes.arrayIndexToVectorIndex(this.coordRow, this.sourceDim);
    }

    @Override
    public void restart() {
        this.nextRow = 0;
    }
}

