/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DefaultValue;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.NamedFlag;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.methods.MethodDispatch;
import org.renjin.primitives.Types;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.primitives.subset.Selections;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Subsetting {
    private Subsetting() {
    }

    private static Symbol asSymbol(SEXP nameExp) {
        if (nameExp instanceof Symbol) {
            return (Symbol)nameExp;
        }
        if (nameExp instanceof StringVector && nameExp.length() == 1) {
            return Symbol.get(((StringVector)nameExp).getElementAsString(0));
        }
        throw new EvalException("illegal argument: " + nameExp, new Object[0]);
    }

    public static SEXP setElementByName(ExternalPtr<?> externalPtr, String name, SEXP value) {
        externalPtr.setMember(Symbol.get(name), value);
        return externalPtr;
    }

    @Builtin(value="@")
    public static SEXP getSlotValue(@Current Context context, @Current MethodDispatch methods, SEXP object2, @Unevaluated Symbol slotName) {
        if (slotName.getPrintName().equals(".Data")) {
            return context.evaluate(FunctionCall.newCall(Symbol.get("getDataPart"), object2), methods.getMethodsNamespace());
        }
        if (!Types.isS4(object2)) {
            SEXP className = object2.getAttribute(Symbols.CLASS_NAME);
            if (className.length() == 0) {
                throw new EvalException("trying to get slot \"%s\" from an object of a basic class (\"%s\") with no slots", slotName.getPrintName(), object2.getS3Class().getElementAsString(0));
            }
            throw new EvalException("trying to get slot \"%s\" from an object (class \"%s\") that is not an S4 object ", slotName.getPrintName(), className.getElementAsSEXP(0));
        }
        SEXP value = object2.getAttribute(slotName);
        if (value == Null.INSTANCE) {
            if (slotName == Symbol.get(".S3Class")) {
                throw new EvalException("not implemented: .S3Class", new Object[0]);
            }
            if (slotName == Symbols.NAMES && object2 instanceof ListVector) {
                return value;
            }
            throw new EvalException("cannot get slot %s", slotName);
        }
        if (value == Symbols.S4_NULL) {
            return Null.INSTANCE;
        }
        return value;
    }

    public static SEXP setElementByName(ListVector list2, String name, SEXP value) {
        return Subsetting.setSingleListElementByName(list2.newCopyNamedBuilder(), name, value);
    }

    public static SEXP setElementByName(AtomicVector vector2, String nameToReplace, SEXP value) {
        ListVector.NamedBuilder copyBuilder = ListVector.newNamedBuilder();
        StringVector namesVector = vector2.getAttributes().getNames();
        for (int i = 0; i != vector2.length(); ++i) {
            String elementName = "";
            if (namesVector != null) {
                elementName = namesVector.getElementAsString(i);
            }
            copyBuilder.add(elementName, (SEXP)vector2.getElementAsSEXP(i));
        }
        return Subsetting.setSingleListElementByName(copyBuilder, nameToReplace, value);
    }

    public static SEXP setElementByName(PairList.Node pairList, String name, SEXP value) {
        return Subsetting.setSingleListElementByName(pairList.newCopyBuilder(), name, value);
    }

    public static SEXP setElementByName(Context context, Environment env2, String name, SEXP value) {
        env2.setVariable(context, name, value);
        return env2;
    }

    @Builtin(value=".subset")
    public static SEXP subset(@Current Context context, SEXP source, @ArgumentList ListVector arguments, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        Vector vector2;
        if (source instanceof Vector) {
            vector2 = (Vector)source;
        } else if (source instanceof PairList) {
            vector2 = ((PairList)source).toVector();
        } else {
            throw new EvalException(source.getClass().getName(), new Object[0]);
        }
        return Subsetting.getSubset(context, vector2, arguments, drop2);
    }

    @Builtin(value=".subset2")
    public static SEXP getSingleElementNonGeneric(@Current Context context, SEXP source, @ArgumentList ListVector subscripts, @NamedFlag(value="exact") @DefaultValue(value=true) boolean exact, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        return Subsetting.getSingleElement(context, source, subscripts, exact, drop2);
    }

    @Generic
    @Builtin(value="[[")
    public static SEXP getSingleElement(@Current Context context, SEXP source, @ArgumentList ListVector subscripts, @NamedFlag(value="exact") @DefaultValue(value=true) boolean exact, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        if (source == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        if (source instanceof Environment) {
            return Subsetting.getSingleEnvironmentElement(context, (Environment)source, subscripts);
        }
        if (source instanceof PairList) {
            source = ((PairList)source).toVector();
        }
        if (source instanceof ListVector && Subsetting.isRecursiveIndexingArgument(subscripts)) {
            return Subsetting.getSingleElementRecursively(context, (ListVector)source, (AtomicVector)subscripts.getElementAsSEXP(0), exact, drop2);
        }
        SelectionStrategy selection = Selections.parseSingleSelection(source, Lists.newArrayList((Iterable)subscripts));
        if (source instanceof ListVector) {
            return selection.getSingleListElement((ListVector)source, exact);
        }
        if (source instanceof AtomicVector) {
            return selection.getSingleAtomicVectorElement((AtomicVector)source, exact);
        }
        throw new EvalException("object of type '%s' is not subsettable", source.getTypeName());
    }

    private static SEXP getSingleEnvironmentElement(Context context, Environment source, ListVector subscripts) {
        if (subscripts.length() != 1) {
            throw new EvalException("subsetting an environment requires a single argument", new Object[0]);
        }
        SEXP subscript = subscripts.get(0);
        if (!(subscript instanceof StringVector) || subscript.length() != 1) {
            throw new EvalException("subset argument for environment must be character of length 1", new Object[0]);
        }
        String symbolName = ((StringVector)subscript).getElementAsString(0);
        if (StringVector.isNA(symbolName)) {
            throw new EvalException("subset argument for environment cannot be NA", new Object[0]);
        }
        SEXP value = source.getVariable(context, symbolName);
        if (value == Symbol.UNBOUND_VALUE) {
            return Null.INSTANCE;
        }
        return value;
    }

    private static boolean isRecursiveIndexingArgument(Iterable<SEXP> subscripts) {
        Iterator<SEXP> it = subscripts.iterator();
        if (!it.hasNext()) {
            return false;
        }
        SEXP subscript = it.next();
        return subscript instanceof AtomicVector && subscript.length() > 1;
    }

    private static SEXP getSingleElementRecursively(Context context, ListVector source, AtomicVector indexes, boolean exact, boolean drop2) {
        assert (indexes.length() > 0);
        SEXP result = source;
        for (int i = 0; i < indexes.length(); ++i) {
            if (!(result instanceof Vector)) {
                throw new EvalException("Recursive indexing failed at level %d", i + 1);
            }
            result = Subsetting.getSingleElement(context, result, new ListVector(new SEXP[]{indexes.getElementAsSEXP(i)}), exact, drop2);
        }
        return result;
    }

    @Generic
    @Builtin(value="[")
    public static SEXP getSubset(@Current Context context, SEXP source, @ArgumentList ListVector subscripts, @NamedFlag(value="drop") @DefaultValue(value=true) boolean drop2) {
        if (source == Null.INSTANCE) {
            return Null.INSTANCE;
        }
        SelectionStrategy selection = Selections.parseSelection(source, Lists.newArrayList((Iterable)subscripts));
        if (source instanceof Vector) {
            return selection.getVectorSubset(context, (Vector)source, drop2);
        }
        if (source instanceof FunctionCall) {
            return FunctionCall.newCallFromVector((ListVector)selection.getVectorSubset(context, ((FunctionCall)source).toVector(), drop2));
        }
        if (source instanceof PairList.Node) {
            return selection.getVectorSubset(context, ((PairList.Node)source).toVector(), drop2);
        }
        throw new EvalException("object of type '%s' is not subsettable", source.getTypeName());
    }

    @Generic
    @Builtin(value="[<-")
    public static SEXP setSubset(@Current Context context, SEXP source, @ArgumentList ListVector argumentList) {
        SEXP replacementExp = argumentList.getElementAsSEXP(argumentList.length() - 1);
        if (!(replacementExp instanceof Vector)) {
            throw new EvalException("incompatible types (from %s to %s) in subassignment type fix", replacementExp.getTypeName(), source.getTypeName());
        }
        Vector replacement = (Vector)replacementExp;
        if (source.length() == 0 && replacement.length() == 0) {
            return source;
        }
        ArrayList subscripts = Lists.newArrayListWithCapacity((int)(argumentList.length() - 1));
        for (int i = 0; i < argumentList.length() - 1; ++i) {
            subscripts.add(argumentList.get(i));
        }
        SelectionStrategy selection = Selections.parseSelection(source, subscripts);
        if (source instanceof ListVector) {
            return selection.replaceListElements(context, (ListVector)source, replacement);
        }
        if (source instanceof FunctionCall) {
            return FunctionCall.newCallFromVector(selection.replaceListElements(context, ((PairList.Node)source).toVector(), replacement));
        }
        if (source instanceof PairList.Node) {
            return selection.replaceListElements(context, ((PairList.Node)source).toVector(), replacement);
        }
        if (source instanceof AtomicVector) {
            return selection.replaceAtomicVectorElements(context, (AtomicVector)source, replacement);
        }
        throw new EvalException("object of type '%' is not subsettable", source.getTypeName());
    }

    @Generic
    @Builtin(value="[[<-")
    public static SEXP setSingleElement(@Current Context context, SEXP source, @ArgumentList ListVector argumentList) {
        if (source instanceof Environment) {
            return Subsetting.setSingleEnvironmentElement(context, (Environment)source, argumentList);
        }
        SEXP replacement = argumentList.getElementAsSEXP(argumentList.length() - 1);
        ArrayList subscripts = Lists.newArrayListWithCapacity((int)(argumentList.length() - 1));
        for (int i = 0; i < argumentList.length() - 1; ++i) {
            subscripts.add(argumentList.get(i));
        }
        if (source instanceof ListVector && Subsetting.isRecursiveIndexingArgument(subscripts)) {
            return Subsetting.replaceSingleListElementRecursively(context, (ListVector)source, argumentList, replacement);
        }
        SelectionStrategy selection = Selections.parseSingleSelection(source, subscripts);
        if (source instanceof PairList.Node) {
            return selection.replaceSinglePairListElement((PairList.Node)source, replacement);
        }
        if (source instanceof ListVector) {
            return selection.replaceSingleListElement((ListVector)source, replacement);
        }
        if (source instanceof Null) {
            if (replacement instanceof AtomicVector && replacement.length() == 1) {
                return selection.replaceSingleElement(LogicalVector.EMPTY, (Vector)replacement);
            }
            return selection.replaceSingleListElement(new ListVector(new SEXP[0]), replacement);
        }
        if (source instanceof AtomicVector) {
            if (!(replacement instanceof Vector)) {
                throw new EvalException("incompatible types", new Object[0]);
            }
            return selection.replaceSingleElement((AtomicVector)source, (Vector)replacement);
        }
        throw new EvalException("object of type '%s' is not subsettable", new Object[0]);
    }

    private static SEXP replaceSingleListElementRecursively(Context context, ListVector source, ListVector argumentList, SEXP replacement) {
        int i;
        SEXP indexes = argumentList.get(0);
        int lastIndex = indexes.length() - 1;
        int leafIndex = lastIndex - 1;
        SelectionStrategy[] subscriptsArray = new SelectionStrategy[indexes.length()];
        for (int i2 = 0; i2 <= lastIndex; ++i2) {
            subscriptsArray[i2] = Selections.parseSingleSelection(source, Collections.singletonList(indexes.getElementAsSEXP(i2)));
        }
        Vector[] sources = new Vector[indexes.length()];
        sources[0] = source;
        for (i = 1; i <= lastIndex; ++i) {
            Vector previousSource = sources[i - 1];
            if (!(previousSource instanceof ListVector)) {
                throw new EvalException("recursive indexing failed at level " + i, new Object[0]);
            }
            sources[i] = (Vector)subscriptsArray[i - 1].getSingleListElement((ListVector)previousSource, false);
        }
        replacement = sources[lastIndex] instanceof AtomicVector ? subscriptsArray[lastIndex].replaceAtomicVectorElements(context, (AtomicVector)sources[lastIndex], (Vector)replacement) : subscriptsArray[lastIndex].replaceSingleListElement((ListVector)sources[lastIndex], replacement);
        for (i = leafIndex; i >= 0; --i) {
            replacement = subscriptsArray[i].replaceSingleListElement((ListVector)sources[i], replacement);
        }
        return replacement;
    }

    private static Environment setSingleEnvironmentElement(Context context, Environment source, ListVector arguments) {
        if (arguments.length() != 2) {
            throw new EvalException("wrong args for environment subassignment", new Object[0]);
        }
        SEXP subscriptExp = arguments.getElementAsSEXP(0);
        SEXP value = arguments.getElementAsSEXP(1);
        if (!(subscriptExp instanceof StringVector) || subscriptExp.length() != 1) {
            throw new EvalException("wrong args for environment subassignment", new Object[0]);
        }
        StringVector subscript = (StringVector)subscriptExp;
        source.setVariable(context, subscript.getElementAsString(0), value);
        return source;
    }

    private static SEXP setSingleListElementByName(ListBuilder builder, String nameToReplace, SEXP replacement) {
        int index = builder.getIndexByName(nameToReplace);
        boolean dropDimensions = false;
        if (replacement == Null.INSTANCE) {
            if (index != -1) {
                builder.remove(index);
                dropDimensions = true;
            }
        } else if (index == -1) {
            builder.add(nameToReplace, replacement);
            dropDimensions = true;
        } else {
            builder.set(index, replacement);
        }
        if (dropDimensions) {
            builder.removeAttribute(Symbols.DIM);
        }
        return builder.build();
    }
}

