/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text.regex;

import org.renjin.eval.EvalException;
import org.renjin.primitives.text.regex.EmptyFixedRE;
import org.renjin.primitives.text.regex.ExtendedRE;
import org.renjin.primitives.text.regex.FixedRE;
import org.renjin.primitives.text.regex.RE;
import org.renjin.primitives.text.regex.RESyntaxException;
import org.renjin.repackaged.guava.base.Predicate;

public class REFactory {
    public static RE compile(String pattern, boolean ignoreCase, boolean perl, boolean fixed, boolean useBytes) {
        try {
            if (fixed) {
                if (pattern.length() == 0) {
                    return new EmptyFixedRE();
                }
                return new FixedRE(pattern);
            }
            if (!perl && pattern.equals("*")) {
                return new EmptyFixedRE();
            }
            return new ExtendedRE(pattern, ignoreCase);
        }
        catch (RESyntaxException e) {
            throw new EvalException("Invalid pattern '%s': %s (perl=%s, fixed=%s)", pattern, e.getMessage(), perl ? "TRUE" : "FALSE", fixed ? "TRUE" : "FALSE");
        }
    }

    public static Predicate<String> asPredicate(final RE re) {
        return new Predicate<String>(){

            public boolean apply(String input) {
                return re.match(input);
            }
        };
    }
}

