/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.vector;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class IsNaVector
extends LogicalVector
implements DeferredComputation {
    private final Vector vector;

    public IsNaVector(Vector vector2) {
        super(IsNaVector.buildAttributes(vector2));
        this.vector = vector2;
    }

    private static AttributeMap buildAttributes(Vector vector2) {
        AttributeMap sourceAttributes = vector2.getAttributes();
        return AttributeMap.builder().addIfNotNull(sourceAttributes, Symbols.DIM).addIfNotNull(sourceAttributes, Symbols.NAMES).addIfNotNull(sourceAttributes, Symbols.DIMNAMES).validateAndBuildFor(vector2);
    }

    private IsNaVector(AttributeMap attributes2, Vector vector2) {
        super(attributes2);
        this.vector = vector2;
    }

    @Override
    public int length() {
        return this.vector.length();
    }

    @Override
    public int getElementAsRawLogical(int index) {
        return this.vector.isElementNaN(index) ? 1 : 0;
    }

    @Override
    public boolean isConstantAccessTime() {
        return this.vector.isConstantAccessTime();
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new IsNaVector(attributes2, this.vector);
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.vector};
    }

    @Override
    public String getComputationName() {
        return "is.na";
    }
}

