/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.vector;

import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class RowNamesVector
extends StringVector {
    private final int length;

    public RowNamesVector(int length2, AttributeMap attributes2) {
        super(attributes2);
        this.length = length2;
    }

    public RowNamesVector(int numRows) {
        this(numRows, AttributeMap.EMPTY);
    }

    @Override
    public String getElementAsString(int index) {
        return Integer.toString(index + 1);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new RowNamesVector(this.length, attributes2);
    }

    public static boolean isOldCompactForm(Vector rowNames) {
        return rowNames.length() == 2 && rowNames.isElementNA(0) && rowNames.getElementAsInt(1) < 0;
    }

    public static RowNamesVector fromOldCompactForm(SEXP rowNames) {
        Preconditions.checkArgument((boolean)RowNamesVector.isOldCompactForm(rowNames));
        int numRows = -((Vector)rowNames).getElementAsInt(1);
        return new RowNamesVector(numRows, AttributeMap.EMPTY);
    }

    public static boolean isOldCompactForm(SEXP rowNames) {
        if (rowNames instanceof Vector) {
            return RowNamesVector.isOldCompactForm((Vector)rowNames);
        }
        return false;
    }

    public static Vector purify(SEXP sexp) {
        if (RowNamesVector.isOldCompactForm(sexp)) {
            return RowNamesVector.fromOldCompactForm(sexp);
        }
        return (Vector)sexp;
    }
}

