/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class ComplexArrayVector
extends ComplexVector {
    private final double[] values;

    public ComplexArrayVector(Complex ... values) {
        this(values, values.length, AttributeMap.EMPTY);
    }

    private ComplexArrayVector(double[] realComplexValues, AttributeMap attributes2) {
        super(attributes2);
        this.values = realComplexValues;
    }

    public ComplexArrayVector(ComplexVector vector2) {
        this(vector2.toComplexArray(), vector2.getAttributes());
    }

    public static ComplexArrayVector fromRealArray(double[] realValues, AttributeMap attributes2) {
        double[] values = new double[realValues.length * 2];
        for (int i = 0; i < realValues.length; ++i) {
            values[i * 2] = realValues[i];
        }
        return new ComplexArrayVector(values, attributes2);
    }

    public double[] toComplexArrayVectorUnsafe() {
        return this.values;
    }

    public ComplexArrayVector(Complex[] values, AttributeMap attributes2) {
        this(values, values.length, attributes2);
    }

    public ComplexArrayVector(Complex[] values, int length2, AttributeMap attributes2) {
        super(attributes2);
        this.values = new double[length2 * 2];
        for (int i = 0; i < length2; ++i) {
            this.values[i * 2] = values[i].getReal();
            this.values[i * 2 + 1] = values[i].getImaginary();
        }
    }

    public ComplexArrayVector(Complex[] values, int length2) {
        this(values, length2, AttributeMap.EMPTY);
    }

    public static ComplexVector newMatrix(Complex[] values, int nRows, int nCols) {
        return new ComplexArrayVector(values, AttributeMap.builder().setDim(nRows, nCols).build());
    }

    @Override
    public int length() {
        return this.values.length / 2;
    }

    @Override
    public Complex getElementAsComplex(int index) {
        double real2 = this.values[index * 2];
        double imag = this.values[index * 2 + 1];
        return new Complex(real2, imag);
    }

    public boolean equals(Object x) {
        if (x instanceof ComplexArrayVector) {
            ComplexArrayVector that = (ComplexArrayVector)x;
            return Arrays.equals(this.values, that.values);
        }
        return false;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new ComplexArrayVector(this.values, attributes2);
    }

    @Override
    public boolean isElementNA(int index) {
        return ComplexArrayVector.isNA(new Complex(this.values[index * 2], this.values[index * 2 + 1]));
    }

    @Override
    public Iterator<Complex> iterator() {
        return Arrays.asList(this.toComplexArray()).iterator();
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    public String toString() {
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i = 0; i < this.length(); ++i) {
            if (ComplexArrayVector.isNA(new Complex(this.values[i * 2], this.values[i * 2 + 1]))) {
                list2.add("NA");
                continue;
            }
            list2.add(this.values[i * 2] + "+" + this.values[i * 2 + 1] + "i");
        }
        return list2.toString();
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private static final int MIN_INITIAL_CAPACITY = 50;
        private double[] builderValues;
        private int size;

        public Builder(int initialSize, int initialCapacity) {
            if (initialCapacity < 50) {
                initialCapacity = 50;
            }
            if (initialSize > initialCapacity) {
                initialCapacity = initialSize;
            }
            this.builderValues = new double[initialCapacity * 2];
            this.size = initialSize;
            Arrays.fill(this.builderValues, DoubleVector.NA);
        }

        public Builder() {
            this(0, 50);
        }

        public Builder(int initialSize) {
            this(initialSize, initialSize);
        }

        public Builder(ComplexVector toCopy) {
            this.builderValues = new double[toCopy.length() * 2];
            for (int i = 0; i < toCopy.length(); ++i) {
                this.builderValues[i * 2] = toCopy.getElementAsComplex(i).getReal();
                this.builderValues[i * 2 + 1] = toCopy.getElementAsComplex(i).getImaginary();
            }
            this.size = this.builderValues.length / 2;
            this.copyAttributesFrom(toCopy);
        }

        public static Builder withInitialSize(int size) {
            return new Builder(size, size);
        }

        public static Builder withInitialCapacity(int capacity) {
            return new Builder(0, capacity);
        }

        private Builder(ComplexArrayVector exp2) {
            this.builderValues = Arrays.copyOf(exp2.values, exp2.values.length);
            this.size = exp2.values.length / 2;
            this.copyAttributesFrom(exp2);
        }

        public Builder set(int index, double real2, double imaginary) {
            this.ensureCapacity(index + 1);
            if (index + 1 > this.size) {
                this.size = index + 1;
            }
            this.builderValues[index * 2] = real2;
            this.builderValues[index * 2 + 1] = imaginary;
            return this;
        }

        public Builder set(int index, Complex value) {
            return this.set(index, value.getReal(), value.getImaginary());
        }

        public Builder add(Complex value) {
            return this.set(this.size, value);
        }

        @Override
        public Builder add(Number value) {
            return this.add(new Complex(value.doubleValue(), 0.0));
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, ComplexVector.NA);
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, source.getElementAsComplex(sourceIndex));
        }

        @Override
        public int length() {
            return this.size;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.builderValues.length / 2;
            if (minCapacity > oldCapacity) {
                double[] oldData = this.builderValues;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.builderValues = Arrays.copyOf(oldData, newCapacity * 2);
                Arrays.fill(this.builderValues, oldCapacity * 2, this.builderValues.length, DoubleVector.NA);
            }
        }

        @Override
        public ComplexVector build() {
            if (this.builderValues.length != this.size * 2) {
                double[] reseizedArray = Arrays.copyOf(this.builderValues, this.size * 2);
                return new ComplexArrayVector(reseizedArray, this.buildAttributes());
            }
            return new ComplexArrayVector(this.builderValues, this.buildAttributes());
        }
    }
}

