/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Arrays;
import org.renjin.eval.Profiler;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class LogicalArrayVector
extends LogicalVector {
    private int[] values;

    public LogicalArrayVector(boolean ... values) {
        this.values = new int[values.length];
        for (int i = 0; i != values.length; ++i) {
            this.values[i] = values[i] ? 1 : 0;
        }
    }

    public LogicalArrayVector(int[] values, int size, AttributeMap attributes2) {
        super(attributes2);
        if (Profiler.ENABLED) {
            Profiler.memoryAllocated(32, size);
        }
        this.values = Arrays.copyOf(values, size);
    }

    public LogicalArrayVector(int[] values, AttributeMap attributes2) {
        this(values, values.length, attributes2);
    }

    public LogicalArrayVector(int ... values) {
        this(values, values.length, AttributeMap.EMPTY);
    }

    private LogicalArrayVector(AttributeMap attributes2) {
        super(attributes2);
    }

    public LogicalArrayVector(Logical ... values) {
        this.values = new int[values.length];
        for (int i = 0; i != values.length; ++i) {
            this.values[i] = values[i].getInternalValue();
        }
    }

    public LogicalArrayVector(Boolean[] values) {
        this.values = new int[values.length];
        for (int i = 0; i != values.length; ++i) {
            this.values[i] = values[i] != false ? 1 : 0;
        }
    }

    public static LogicalArrayVector unsafe(int[] array2, AttributeMap attributes2) {
        LogicalArrayVector vector2 = new LogicalArrayVector(AttributeMap.EMPTY);
        vector2.values = array2;
        return vector2;
    }

    public static LogicalArrayVector unsafe(int[] array2) {
        return LogicalArrayVector.unsafe(array2, AttributeMap.EMPTY);
    }

    public int[] toIntArrayUnsafe() {
        return this.values;
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    public int getElementAsRawLogical(int index) {
        return this.values[index];
    }

    @Override
    public boolean isElementTrue(int index) {
        return this.values[index] == 1;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new LogicalArrayVector(this.values, attributes2);
    }

    static /* synthetic */ int[] access$102(LogicalArrayVector x0, int[] x1) {
        x0.values = x1;
        return x1;
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private static final int MIN_INITIAL_CAPACITY = 10;
        private int[] values;
        private int size;

        public Builder(int initialSize, int initialCapacity) {
            if (initialCapacity < 10) {
                initialCapacity = 10;
            }
            if (initialSize > initialCapacity) {
                initialCapacity = initialSize;
            }
            this.values = new int[initialCapacity];
            this.size = initialSize;
            Arrays.fill(this.values, LogicalVector.NA);
        }

        public Builder() {
            this(0, 10);
        }

        public Builder(int initialSize) {
            this(initialSize, initialSize);
        }

        public Builder(LogicalVector toClone) {
            this.values = new int[toClone.length()];
            for (int i = 0; i != this.values.length; ++i) {
                this.values[i] = toClone.getElementAsRawLogical(i);
            }
            this.size = this.values.length;
            this.copyAttributesFrom(toClone);
        }

        public Builder add(int value) {
            return this.set(this.size, value);
        }

        public Builder add(boolean value) {
            return this.add(value ? 1 : 0);
        }

        @Override
        public Builder add(Number value) {
            return this.add(value.intValue() != 0 ? 1 : 0);
        }

        public Builder set(int index, int value) {
            this.ensureCapacity(index + 1);
            if (index + 1 > this.size) {
                this.size = index + 1;
            }
            this.values[index] = value;
            return this;
        }

        public Builder set(int index, boolean value) {
            return this.set(index, value ? 1 : 0);
        }

        public Builder set(int index, Logical value) {
            return this.set(index, value.getInternalValue());
        }

        @Override
        public Builder setNA(int index) {
            return this.set(index, LogicalVector.NA);
        }

        public Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, source.getElementAsRawLogical(sourceIndex));
        }

        @Override
        public int length() {
            return this.size;
        }

        public void ensureCapacity(int minCapacity) {
            int oldCapacity = this.values.length;
            if (minCapacity > oldCapacity) {
                int[] oldData = this.values;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                this.values = Arrays.copyOf(oldData, newCapacity);
                Arrays.fill(this.values, oldCapacity, this.values.length, LogicalVector.NA);
            }
        }

        @Override
        public LogicalVector build() {
            if (Profiler.ENABLED) {
                Profiler.memoryAllocated(32, this.size);
            }
            if (this.values.length == this.size) {
                LogicalArrayVector vector2 = new LogicalArrayVector(this.buildAttributes());
                LogicalArrayVector.access$102(vector2, this.values);
                this.values = null;
                return vector2;
            }
            return new LogicalArrayVector(this.values, this.size, this.buildAttributes());
        }
    }
}

