/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Arrays;
import java.util.Collection;
import org.renjin.eval.EvalException;
import org.renjin.eval.Profiler;
import org.renjin.parser.NumericLiterals;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class StringArrayVector
extends StringVector
implements Iterable<String> {
    protected final String[] values;

    public StringArrayVector(String[] values, AttributeMap attributes2) {
        super(attributes2);
        if (Profiler.ENABLED) {
            Profiler.memoryAllocated(32, values.length);
        }
        this.values = (String[])Arrays.copyOf(values, values.length, String[].class);
        assert (this.checkDims()) : "dim do not match length of object";
    }

    public StringArrayVector(String ... values) {
        this((String[])Arrays.copyOf(values, values.length, String[].class), AttributeMap.EMPTY);
    }

    public StringArrayVector(Iterable<String> properties) {
        this((String[])Iterables.toArray(properties, String.class), AttributeMap.EMPTY);
    }

    public StringArrayVector(Collection<String> values, AttributeMap attributes2) {
        this(values.toArray(new String[values.size()]), attributes2);
    }

    public StringArrayVector(Collection<String> values) {
        this(values, AttributeMap.EMPTY);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    public StringVector setLength(int newLength) {
        if (newLength == this.values.length) {
            return this;
        }
        String[] newValues = new String[newLength];
        for (int i = 0; i != newValues.length; ++i) {
            newValues[i] = i < this.values.length ? this.values[i] : StringVector.NA;
        }
        return new StringArrayVector(newValues);
    }

    @Override
    public String getElementAsString(int index) {
        return this.values[index];
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public double asReal() {
        if (this.values.length > 0 && this.values[0] != null && this.values[0].length() > 0) {
            return NumericLiterals.parseDouble(this.values[0]);
        }
        return DoubleVector.NA;
    }

    @Override
    protected StringArrayVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new StringArrayVector(this.values, attributes2);
    }

    @Override
    public String[] toArray() {
        return (String[])this.values.clone();
    }

    public static StringArrayVector coerceFrom(SEXP exp2) {
        if (exp2 instanceof Vector) {
            return StringArrayVector.fromVector((Vector)exp2);
        }
        if (exp2 instanceof Symbol) {
            return new StringArrayVector(((Symbol)exp2).getPrintName());
        }
        throw new EvalException("cannot coerce type '%s' to vector of type 'character'", exp2.getTypeName());
    }

    public static StringArrayVector fromVector(Vector vector2) {
        StringVector.Builder result = new StringVector.Builder();
        for (int i = 0; i != vector2.length(); ++i) {
            result.add(vector2.getElementAsString(i));
        }
        return result.build();
    }
}

