/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.parser.NumericLiterals;
import org.renjin.primitives.vector.ConvertingStringVector;
import org.renjin.repackaged.guava.base.Objects;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Vector;

public abstract class StringVector
extends AbstractAtomicVector
implements Iterable<String> {
    public static final String TYPE_NAME = "character";
    public static final String NA = null;
    public static final Vector.Type VECTOR_TYPE = new StringType();
    public static final StringVector EMPTY = new StringArrayVector(new String[0]);

    public StringVector(AttributeMap attributes2) {
        super(attributes2);
    }

    public static StringVector valueOf(String string) {
        return new StringArrayVector(string);
    }

    @Override
    public int getElementAsRawLogical(int index) {
        String value = this.getElementAsString(index);
        return StringVector.logicalFromString(value);
    }

    public static int logicalFromString(String value) {
        if (StringVector.isNA(value)) {
            return Integer.MIN_VALUE;
        }
        if (value.equals("T") || value.equals("TRUE") || value.equals("true")) {
            return 1;
        }
        if (value.equals("F") || value.equals("FALSE") || value.equals("false")) {
            return 0;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getElementAsInt(int index) {
        if (this.isElementNA(index)) {
            return Integer.MIN_VALUE;
        }
        String value = this.getElementAsString(index);
        double doubleValue = NumericLiterals.parseDouble(value, 0, value.length(), '.', true);
        if (DoubleVector.isFinite(doubleValue)) {
            return (int)doubleValue;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public double getElementAsDouble(int index) {
        if (this.isElementNA(index)) {
            return DoubleVector.NA;
        }
        return NumericLiterals.parseDouble(this.getElementAsString(index));
    }

    @Override
    public Complex getElementAsComplex(int index) {
        String stringValue = this.getElementAsString(index);
        if (StringVector.isNA(stringValue)) {
            return ComplexVector.NA;
        }
        return NumericLiterals.parseComplex(stringValue);
    }

    public static boolean isNA(String s) {
        return s == NA;
    }

    @Override
    public Logical asLogical() {
        if (this.length() >= 1) {
            String value = this.getElementAsString(0);
            if ("true".equals(value) || "TRUE".equals(value) || "T".equals(value)) {
                return Logical.TRUE;
            }
            if ("false".equals(value) || "FALSE".equals(value) || "F".equals(value)) {
                return Logical.FALSE;
            }
        }
        return Logical.NA;
    }

    public SEXP getElementAsSEXP(int index) {
        return new StringArrayVector(this.getElementAsString(index));
    }

    @Override
    public String asString() {
        if (this.length() == 1) {
            return this.getElementAsString(0);
        }
        return super.asString();
    }

    @Override
    public String getElementAsObject(int index) {
        return this.getElementAsString(index);
    }

    @Override
    public Builder newCopyBuilder() {
        return new Builder(this);
    }

    @Override
    public Builder newBuilderWithInitialSize(int initialSize) {
        return new Builder(initialSize, 0);
    }

    @Override
    public Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new Builder(0, initialCapacity);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    public boolean isElementNA(int index) {
        return StringVector.isNA(this.getElementAsString(index));
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        if (vector2.isElementNA(vectorIndex)) {
            return this.indexOfNA();
        }
        String value = vector2.getElementAsString(vectorIndex);
        return this.indexOf(value, startIndex);
    }

    @Override
    public abstract int length();

    @Override
    protected abstract StringVector cloneWithNewAttributes(AttributeMap var1);

    @Override
    public int compare(int index1, int index2) {
        return this.getElementAsString(index1).compareTo(this.getElementAsString(index2));
    }

    private int indexOf(String value, int startIndex) {
        for (int i = startIndex; i < this.length(); ++i) {
            String value_i = this.getElementAsString(i);
            if (value_i == null || !value_i.equals(value)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(String value) {
        return this.indexOf(value, 0);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof StringVector)) {
            return false;
        }
        StringVector that = (StringVector)o;
        if (that.length() != this.length()) {
            return false;
        }
        for (int i = 0; i != this.length(); ++i) {
            if (Objects.equal((Object)this.getElementAsString(i), (Object)that.getElementAsString(i))) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int hash = 37;
        for (int i = 0; i != this.length(); ++i) {
            String s_i = this.getElementAsString(i);
            hash += s_i == null ? 0 : s_i.hashCode();
        }
        return hash;
    }

    public String toString() {
        if (this.length() == 1) {
            return this.isElementNA(0) ? "NA_character_" : this.getElementAsString(0);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("c(");
        for (int i = 0; i < Math.min(5, this.length()); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this.isElementNA(i)) {
                sb.append("NA_character_");
                continue;
            }
            sb.append(this.getElementAsString(i));
        }
        if (this.length() > 5) {
            sb.append("...").append(this.length()).append(" elements total");
        }
        sb.append(")");
        return sb.toString();
    }

    public String[] toArray() {
        String[] array2 = new String[this.length()];
        for (int i = 0; i != array2.length; ++i) {
            array2[i] = this.getElementAsString(i);
        }
        return array2;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterator<String> iterator() {
        return new UnmodifiableIterator<String>(){
            private int index = 0;

            public boolean hasNext() {
                return this.index < StringVector.this.length();
            }

            public String next() {
                return StringVector.this.getElementAsString(this.index++);
            }
        };
    }

    public static class Builder
    extends AbstractAtomicVector.AbstractAtomicBuilder {
        private ArrayList<String> values;
        private boolean haveNonEmpty = false;

        public Builder(int initialSize, int initialCapacity) {
            this.values = Lists.newArrayListWithCapacity((int)initialCapacity);
            for (int i = 0; i != initialSize; ++i) {
                this.values.add(StringArrayVector.NA);
            }
        }

        public Builder() {
            this(0, 15);
        }

        public Builder(StringVector toClone) {
            this.values = Lists.newArrayList();
            Iterables.addAll(this.values, (Iterable)toClone);
            this.copyAttributesFrom(toClone);
        }

        public Builder(int initialSize) {
            this.values = new ArrayList(initialSize);
            for (int i = 0; i != initialSize; ++i) {
                this.values.add(StringArrayVector.NA);
            }
        }

        public Vector.Builder set(int index, String value) {
            while (this.values.size() <= index) {
                this.values.add(StringArrayVector.NA);
            }
            this.values.set(index, value);
            if (value != null && !value.isEmpty()) {
                this.haveNonEmpty = true;
            }
            return this;
        }

        public void add(String value) {
            this.values.add(value);
            if (value != null && !value.isEmpty()) {
                this.haveNonEmpty = true;
            }
        }

        @Override
        public Vector.Builder add(Number value) {
            this.add(NumericLiterals.toString(value.doubleValue()));
            return this;
        }

        public Builder addAll(Iterable<String> values) {
            for (String value : values) {
                this.add(value);
            }
            return this;
        }

        @Override
        public Vector.Builder setNA(int index) {
            return this.set(index, StringArrayVector.NA);
        }

        @Override
        public Vector.Builder setFrom(int destinationIndex, Vector source, int sourceIndex) {
            return this.set(destinationIndex, source.getElementAsString(sourceIndex));
        }

        public boolean haveNonEmpty() {
            return this.haveNonEmpty;
        }

        @Override
        public int length() {
            return this.values.size();
        }

        @Override
        public StringArrayVector build() {
            return new StringArrayVector(this.values, this.buildAttributes());
        }
    }

    private static class StringType
    extends Vector.Type {
        public StringType() {
            super(6);
        }

        @Override
        public Vector.Builder newBuilder() {
            return new Builder();
        }

        @Override
        public Builder newBuilderWithInitialSize(int initialSize) {
            return new Builder(initialSize);
        }

        @Override
        public Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new Builder(0, initialCapacity);
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new StringArrayVector(vector2.getElementAsString(index));
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            return vector1.getElementAsString(index1).compareTo(vector2.getElementAsString(index2));
        }

        @Override
        public boolean elementsEqual(Vector vector1, int index1, Vector vector2, int index2) {
            String s1 = vector1.getElementAsString(index1);
            String s2 = vector2.getElementAsString(index2);
            if (s1 == null || s2 == null) {
                return false;
            }
            return s1.equals(s2);
        }

        @Override
        public Vector to(Vector x) {
            if (x instanceof StringVector) {
                return x;
            }
            return new ConvertingStringVector(x, x.getAttributes());
        }
    }
}

