/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Date;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Session;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.stats.internals.distributions.MersenneTwister;
import org.renjin.stats.internals.distributions.N01type;
import org.renjin.stats.internals.distributions.RNGtype;

public class RNG {
    public MersenneTwister mersenneTwisterAlg = null;
    public RNGtype RNG_kind = RNGtype.MERSENNE_TWISTER;
    public N01type N01_kind = N01type.INVERSION;
    int randomseed = 0;
    public Session context;
    private MethodHandle methodHandle;

    public RNG(Session globals) {
        this.context = globals;
        this.methodHandle = RNG.createMethodHandle(this);
    }

    @Internal
    public static IntVector RNGkind(@Current Context context, SEXP kindExp, SEXP normalkindExp) {
        RNG rng = context.getSession().rng;
        if (kindExp != Null.INSTANCE) {
            int kind = ((AtomicVector)kindExp).getElementAsInt(0);
            try {
                rng.RNG_kind = RNGtype.values()[kind];
            }
            catch (Exception e) {
                throw new EvalException("RNGkind: unimplemented RNG kind " + kind, new Object[0]);
            }
        }
        if (normalkindExp != Null.INSTANCE) {
            int normalkind = ((AtomicVector)normalkindExp).getElementAsInt(0);
            try {
                rng.N01_kind = N01type.values()[normalkind];
            }
            catch (Exception e) {
                throw new EvalException("invalid Normal type in RNGkind", new Object[0]);
            }
        }
        return new IntArrayVector(rng.RNG_kind.ordinal(), rng.N01_kind.ordinal());
    }

    @Internal(value="set.seed")
    public static void set_seed(@Current Context context, int seed2, SEXP kind, SEXP normalkind) {
        RNG rng = context.getSession().rng;
        rng.randomseed = seed2;
        RNG.RNGkind(context, kind, normalkind);
        switch (rng.RNG_kind) {
            case WICHMANN_HILL: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MARSAGLIA_MULTICARRY: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case SUPER_DUPER: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MERSENNE_TWISTER: {
                if (rng.mersenneTwisterAlg == null) {
                    rng.mersenneTwisterAlg = new MersenneTwister(seed2);
                } else {
                    rng.mersenneTwisterAlg.setSeed(seed2);
                }
                return;
            }
            case KNUTH_TAOCP: 
            case KNUTH_TAOCP2: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case USER_UNIF: {
                throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
            }
        }
        throw new EvalException((Object)((Object)rng.RNG_kind) + " not implemented yet", new Object[0]);
    }

    public double unif_rand() {
        switch (this.RNG_kind) {
            case WICHMANN_HILL: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MARSAGLIA_MULTICARRY: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case SUPER_DUPER: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MERSENNE_TWISTER: {
                if (this.mersenneTwisterAlg == null) {
                    if (this.randomseed == 0) {
                        this.Randomize(this.RNG_kind);
                    }
                    this.mersenneTwisterAlg = new MersenneTwister(this.randomseed);
                }
                return this.mersenneTwisterAlg.nextDouble();
            }
            case KNUTH_TAOCP: 
            case KNUTH_TAOCP2: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case USER_UNIF: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
        }
        throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
    }

    public void Randomize(RNGtype kind) {
        int sseed;
        this.randomseed = sseed = (int)new Date().getTime();
        switch (this.RNG_kind) {
            case WICHMANN_HILL: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MARSAGLIA_MULTICARRY: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case SUPER_DUPER: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case MERSENNE_TWISTER: {
                if (this.mersenneTwisterAlg == null) {
                    this.mersenneTwisterAlg = new MersenneTwister(sseed);
                } else {
                    this.mersenneTwisterAlg.setSeed(sseed);
                }
                return;
            }
            case KNUTH_TAOCP: 
            case KNUTH_TAOCP2: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
            case USER_UNIF: {
                throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
            }
        }
        throw new EvalException((Object)((Object)this.RNG_kind) + " not implemented yet", new Object[0]);
    }

    private static MethodHandle createMethodHandle(RNG rng) {
        try {
            MethodHandle instanceMethod = MethodHandles.publicLookup().findVirtual(RNG.class, "unif_rand", MethodType.methodType(Double.TYPE));
            MethodHandle staticMethod = MethodHandles.insertArguments(instanceMethod, 0, rng);
            return staticMethod;
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new IllegalStateException("getMethodHandle() failed: " + e.getMessage(), e);
        }
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }
}

