/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.EvalException;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;
import org.renjin.stats.internals.models.ContrastMatrix;
import org.renjin.stats.internals.models.DummyColumn;
import org.renjin.stats.internals.models.ModelMatrixColumn;
import org.renjin.stats.internals.models.Variable;

public class FactorVariable
extends Variable {
    private final String name;
    private final Vector vector;
    private ContrastMatrix contrastMatrix;

    public FactorVariable(String name, SEXP vector2) {
        this.name = name;
        this.vector = (Vector)vector2;
        SEXP contrasts = vector2.getAttribute(Symbol.get("contrasts"));
        if (contrasts == Null.INSTANCE) {
            throw new EvalException("Invalid contrast matrix for " + name, new Object[0]);
        }
        this.contrastMatrix = new ContrastMatrix(contrasts);
    }

    public List<ModelMatrixColumn> getModelMatrixColumns() {
        ArrayList columns = Lists.newArrayList();
        for (int i = 0; i != this.contrastMatrix.getNumDummyVariables(); ++i) {
            columns.add(new DummyColumn(this.name + this.contrastMatrix.getDummyVariableName(i), this.vector, this.contrastMatrix, i));
        }
        return columns;
    }
}

