/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.models;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Iterators;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.stats.internals.models.Term;

public class TermList
implements Iterable<Term> {
    private List<Term> list = Lists.newArrayList();

    public void add(Term term) {
        if (!this.list.contains(term)) {
            this.list.add(term);
        }
    }

    public void add(TermList termsToAdd) {
        Iterables.addAll(this.list, (Iterable)termsToAdd);
    }

    public void subtract(Term term) {
        this.list.remove(term);
    }

    public void subtract(TermList toRemove) {
        for (Term term : toRemove) {
            this.subtract(term);
        }
    }

    public TermList sorted() {
        Collections.sort(this.list, new Comparator<Term>(){

            @Override
            public int compare(Term a, Term b) {
                return a.getExpressions().size() - b.getExpressions().size();
            }
        });
        return this;
    }

    @Override
    public Iterator<Term> iterator() {
        return Iterators.unmodifiableIterator(this.list.iterator());
    }
}

