/*
 * Decompiled with CFR 0.152.
 */
package org.structr.agent;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.agent.AgentService;
import org.structr.agent.ReturnValue;
import org.structr.agent.StatusInfo;
import org.structr.agent.Task;
import org.structr.core.Services;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;

public abstract class Agent<T extends NodeInterface>
extends Thread
implements StatusInfo {
    public static final String AVERAGE_EXECUTION_TIME = "average_execution_time";
    public static final String EXECUTION_STATUS = "execution_status";
    public static final String MAX_QUEUE_SIZE = "max_queue_size";
    private static final Logger logger = LoggerFactory.getLogger((String)Agent.class.getName());
    private final AtomicBoolean acceptingTasks = new AtomicBoolean(true);
    private AgentService agentService = null;
    private long averageExecutionTime = 0L;
    private Task currentTask = null;
    private long lastStartTime = 0L;
    private int maxAgents = 4;
    private int maxQueueSize = 10;
    private final AtomicBoolean suspended = new AtomicBoolean(false);
    private final Queue<Task<T>> taskQueue = new ConcurrentLinkedQueue<Task<T>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.agentService.notifyAgentStart(this);
        while (true) {
            if (this.suspended.get()) {
                Thread.yield();
                continue;
            }
            Queue<Task<T>> queue = this.taskQueue;
            synchronized (queue) {
                this.currentTask = this.taskQueue.poll();
            }
            if (this.currentTask != null) {
                this.lastStartTime = System.nanoTime();
                Enum ret = null;
                if (Services.getInstance().isInitialized()) {
                    if (this.createEnclosingTransaction()) {
                        try (Tx tx = StructrApp.getInstance().tx();){
                            ret = this.processTask(this.currentTask);
                            tx.success();
                        }
                        catch (Throwable t) {
                            logger.error("Processing task {} failed. Maybe someone killed us?", (Object)this.currentTask.getType(), (Object)t);
                        }
                    } else {
                        try {
                            ret = this.processTask(this.currentTask);
                        }
                        catch (Throwable t) {
                            logger.error("Processing task {} failed. Maybe someone killed us?", (Object)this.currentTask.getType(), (Object)t);
                        }
                    }
                }
                if (ret != null) {
                    switch (1.$SwitchMap$org$structr$agent$ReturnValue[ret.ordinal()]) {
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                }
                long endTime = System.nanoTime();
                this.averageExecutionTime += endTime;
                this.averageExecutionTime /= 2L;
            } else {
                this.acceptingTasks.set(false);
            }
            if (!this.acceptingTasks.get()) break;
        }
        this.beforeShutdown();
        this.agentService.notifyAgentStop(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean assignTask(Task<T> task) {
        if (this.canHandleMore() && this.acceptingTasks.get()) {
            Queue<Task<T>> queue = this.taskQueue;
            synchronized (queue) {
                this.taskQueue.add(task);
            }
            return true;
        }
        return false;
    }

    public final void killAgent() {
        this.acceptingTasks.set(false);
        this.taskQueue.clear();
        this.interrupt();
    }

    public final void suspendAgent() {
        this.acceptingTasks.set(false);
        this.suspended.set(true);
    }

    public final void resumeAgent() {
        this.acceptingTasks.set(true);
        this.suspended.set(false);
    }

    protected void beforeShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canHandleMore() {
        int size = 0;
        Queue<Task<T>> queue = this.taskQueue;
        synchronized (queue) {
            size = this.taskQueue.size();
        }
        if (size == 0) {
            return true;
        }
        long actualExecutionTime = System.nanoTime() - this.lastStartTime;
        long upperThreshold = this.averageExecutionTime + this.averageExecutionTime / 2L;
        long lowerThreshold = this.averageExecutionTime - this.averageExecutionTime / 2L;
        if (actualExecutionTime > upperThreshold && this.maxQueueSize > 2) {
            this.maxQueueSize -= 2;
            return false;
        }
        if (actualExecutionTime < lowerThreshold && this.maxQueueSize < 200) {
            this.maxQueueSize += 2;
            return true;
        }
        return size < this.maxQueueSize;
    }

    public abstract ReturnValue processTask(Task<T> var1) throws Throwable;

    public boolean createEnclosingTransaction() {
        return true;
    }

    public final Task<T> getCurrentTask() {
        return this.currentTask;
    }

    public final List<Task<T>> getTaskQueue() {
        LinkedList<Task<T>> ret = new LinkedList<Task<T>>();
        ret.addAll(this.taskQueue);
        return ret;
    }

    public final int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public final long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }

    public int getMaxAgents() {
        return this.maxAgents;
    }

    @Override
    public Object getStatusProperty(String key) {
        if (key.equals(AVERAGE_EXECUTION_TIME)) {
            return this.getAverageExecutionTime();
        }
        if (key.equals(MAX_QUEUE_SIZE)) {
            return this.getMaxQueueSize();
        }
        if (key.equals(EXECUTION_STATUS)) {
            // empty if block
        }
        return null;
    }

    protected AgentService getBlackboardService() {
        return this.agentService;
    }

    public abstract Class getSupportedTaskType();

    public final boolean isSuspended() {
        return this.suspended.get();
    }

    public final boolean isAcceptingTasks() {
        return this.acceptingTasks.get();
    }

    public final void setAgentService(AgentService service) {
        this.setDaemon(false);
        this.agentService = service;
        this.lastStartTime = System.nanoTime();
    }
}

