/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cmis.wrapper;

import java.math.BigInteger;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.spi.BindingsObjectFactory;
import org.structr.cmis.info.CMISDocumentInfo;
import org.structr.cmis.wrapper.CMISObjectWrapper;
import org.structr.cmis.wrapper.FilteredPropertyList;
import org.structr.common.error.FrameworkException;

public class CMISDocumentWrapper
extends CMISObjectWrapper<CMISDocumentInfo> {
    private boolean isImmutable = false;
    private String changeToken = null;
    private String contentType = null;
    private BigInteger fileSize = null;

    public CMISDocumentWrapper(String propertyFilter, Boolean includeAllowableActions) {
        super(BaseTypeId.CMIS_DOCUMENT, propertyFilter, includeAllowableActions);
    }

    @Override
    public void createProperties(BindingsObjectFactory factory, FilteredPropertyList properties) {
        properties.add((PropertyData<?>)factory.createPropertyStringData("cmis:contentStreamMimeType", this.contentType));
        properties.add((PropertyData<?>)factory.createPropertyStringData("cmis:contentStreamFileName", this.getName()));
        properties.add((PropertyData<?>)factory.createPropertyIntegerData("cmis:contentStreamLength", this.fileSize));
        properties.add((PropertyData<?>)factory.createPropertyIdData("cmis:contentStreamId", this.getName()));
        properties.add((PropertyData<?>)factory.createPropertyStringData("cmis:changeToken", this.changeToken));
        properties.add((PropertyData<?>)factory.createPropertyBooleanData("cmis:isImmutable", Boolean.valueOf(this.isImmutable)));
        properties.add((PropertyData<?>)factory.createPropertyIdData("cmis:secondaryObjectTypeIds", (String)null));
        properties.add((PropertyData<?>)factory.createPropertyBooleanData("cmis:isLatestVersion", Boolean.valueOf(true)));
        properties.add((PropertyData<?>)factory.createPropertyBooleanData("cmis:isMajorVersion", Boolean.valueOf(true)));
        properties.add((PropertyData<?>)factory.createPropertyBooleanData("cmis:isLatestMajorVersion", Boolean.valueOf(true)));
        properties.add((PropertyData<?>)factory.createPropertyBooleanData("cmis:isPrivateWorkingCopy", Boolean.valueOf(false)));
        properties.add((PropertyData<?>)factory.createPropertyStringData("cmis:versionLabel", ""));
        properties.add((PropertyData<?>)factory.createPropertyIdData("cmis:versionSeriesId", ""));
        properties.add((PropertyData<?>)factory.createPropertyBooleanData("cmis:isVersionSeriesCheckedOut", Boolean.valueOf(false)));
        properties.add((PropertyData<?>)factory.createPropertyStringData("cmis:versionSeriesCheckedOutBy", (String)null));
        properties.add((PropertyData<?>)factory.createPropertyIdData("cmis:versionSeriesCheckedOutId", (String)null));
        properties.add((PropertyData<?>)factory.createPropertyStringData("cmis:checkinComment", (String)null));
    }

    @Override
    public void initializeFrom(CMISDocumentInfo info) throws FrameworkException {
        super.initializeFrom(info);
        this.contentType = info.getContentType();
        this.changeToken = info.getChangeToken();
        Long size = info.getSize();
        if (size != null) {
            this.fileSize = BigInteger.valueOf(size);
        }
        this.isImmutable = info.isImmutable();
    }
}

