/*
 * Decompiled with CFR 0.152.
 */
package org.structr.cmis.wrapper;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.commons.lang.StringUtils;

public class FilteredPropertyList {
    private final Set<String> acceptedProperties = new LinkedHashSet<String>();
    private final List<PropertyData<?>> list = new LinkedList();
    private boolean doFilter = false;

    public FilteredPropertyList(String propertyFilter) {
        this.initialize(propertyFilter);
        if (StringUtils.isNotBlank((String)propertyFilter) && !"*".equals(propertyFilter)) {
            this.doFilter = true;
        }
    }

    public List<PropertyData<?>> getList() {
        return this.list;
    }

    public void add(PropertyData<?> property) {
        if (property != null && (!this.doFilter || this.acceptedProperties.contains(property.getId()))) {
            this.list.add(property);
        }
    }

    private void initialize(String source) {
        if (source != null) {
            for (String part : source.split("[,]+")) {
                String trimmedPart = part.trim();
                if (trimmedPart.isEmpty()) continue;
                this.acceptedProperties.add(trimmedPart);
            }
        }
    }
}

