/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class CaseHelper {
    public static String toUpperCamelCase(String input) {
        return WordUtils.capitalize((String)input, (char[])new char[]{'_'}).replaceAll("_", "");
    }

    public static String toLowerCamelCase(String input) {
        return input.substring(0, 1).toLowerCase().concat(WordUtils.capitalize((String)input, (char[])new char[]{'_'}).replaceAll("_", "").substring(1));
    }

    public static String toUnderscore(String input, boolean plural) {
        if (input.toUpperCase().equals(input)) {
            return input;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    out.append("_");
                }
                out.append(Character.toLowerCase(c));
                continue;
            }
            out.append(c);
        }
        String output = out.toString();
        return plural ? CaseHelper.plural(output) : output;
    }

    public static void main(String[] args) {
        String[] input = new String[]{"check_ins", "CheckIns", "blog_entry", "BlogEntry", "blog_entries", "BlogEntries", "blogentry", "blogentries"};
        for (int i = 0; i < input.length; ++i) {
            System.out.println(StringUtils.rightPad((String)input[i], (int)20) + StringUtils.leftPad((String)CaseHelper.toUpperCamelCase(input[i]), (int)20) + StringUtils.leftPad((String)CaseHelper.toUnderscore(input[i], true), (int)20) + StringUtils.leftPad((String)CaseHelper.toUnderscore(input[i], false), (int)20));
        }
    }

    public static String plural(String type) {
        int len = type.length();
        if (type.substring(len - 1, len).equals("y")) {
            return type.substring(0, len - 1) + "ies";
        }
        if (!type.substring(len - 1, len).equals("s")) {
            return type.concat("s");
        }
        return type;
    }
}

