/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.api.graph.Label;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.api.util.Iterables;
import org.structr.common.FactoryDefinition;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.GenericNode;
import org.structr.core.entity.GenericRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;

public class DefaultFactoryDefinition
implements FactoryDefinition {
    private static final Logger logger = LoggerFactory.getLogger((String)DefaultFactoryDefinition.class.getName());
    public static final String COMBINED_RELATIONSHIP_KEY_SEP = " ";
    public static final Class GENERIC_NODE_TYPE = GenericNode.class;
    public static final Class GENERIC_REL_TYPE = GenericRelationship.class;
    private String externalNodeTypeName = null;

    @Override
    public AbstractRelationship createGenericRelationship() {
        return new GenericRelationship();
    }

    @Override
    public Class getGenericRelationshipType() {
        return GENERIC_REL_TYPE;
    }

    @Override
    public AbstractNode createGenericNode() {
        return new GenericNode();
    }

    @Override
    public Class getGenericNodeType() {
        return GENERIC_NODE_TYPE;
    }

    @Override
    public boolean isGeneric(Class<?> entityClass) {
        return GenericRelationship.class.isAssignableFrom(entityClass) || GenericNode.class.isAssignableFrom(entityClass);
    }

    @Override
    public Class determineNodeType(Node node) {
        if (TransactionCommand.isDeleted(node)) {
            return null;
        }
        String type = GraphObject.type.dbName();
        if (node.hasProperty(type)) {
            Class<? extends NodeInterface> nodeType;
            Object obj = node.getProperty(type);
            if (obj != null && (nodeType = StructrApp.getConfiguration().getNodeEntities().get(obj.toString())) != null) {
                return nodeType;
            }
        } else {
            Class dynamicType;
            Object typeObj;
            if (this.externalNodeTypeName == null) {
                this.externalNodeTypeName = (String)Settings.ForeignTypeName.getValue();
            }
            if (this.externalNodeTypeName != null && node.hasProperty(this.externalNodeTypeName) && (typeObj = node.getProperty(this.externalNodeTypeName)) != null && (dynamicType = StructrApp.getConfiguration().getNodeEntityClass(typeObj.toString())) != null) {
                return dynamicType;
            }
            Iterable labels = node.getLabels();
            if (labels != null) {
                List sortedLabels = Iterables.toList((Iterable)Iterables.map((Function)new LabelExtractor(), (Iterable)labels));
                Collections.sort(sortedLabels);
                String typeName = StringUtils.join((Iterable)sortedLabels, (String)"");
                Class dynamicType2 = StructrApp.getConfiguration().getNodeEntityClass(typeName);
                if (dynamicType2 != null) {
                    return dynamicType2;
                }
            }
        }
        return this.getGenericNodeType();
    }

    @Override
    public Class determineRelationshipType(Relationship relationship) {
        if (TransactionCommand.isDeleted(relationship)) {
            return null;
        }
        String type = GraphObject.type.dbName();
        String sourceType = relationship.getStartNode().hasProperty(type) ? relationship.getStartNode().getProperty(type).toString() : "";
        String targetType = relationship.getEndNode().hasProperty(type) ? relationship.getEndNode().getProperty(type).toString() : "";
        String relType = relationship.getType().name();
        Class entityType = this.getClassForCombinedType(sourceType, relType, targetType);
        if (entityType != null) {
            logger.debug("Class for assembled combined {}", (Object)entityType.getName());
            return entityType;
        }
        if (relationship.hasProperty(type)) {
            Class relationClass;
            Object obj = relationship.getProperty(type);
            logger.debug("Type property: {}", obj);
            if (obj != null && (relationClass = StructrApp.getConfiguration().getRelationshipEntityClass(obj.toString())) != null) {
                StructrApp.getConfiguration().setRelationClassForCombinedType(sourceType, relType, targetType, relationClass);
                return relationClass;
            }
        }
        String combinedTypeName = "combinedType";
        if (relationship.hasProperty("combinedType")) {
            Class classForCombinedType;
            Object obj = relationship.getProperty("combinedType");
            logger.debug("Combined type property: {}", obj);
            if (obj != null && (classForCombinedType = this.getClassForCombinedType(obj.toString())) != null) {
                return classForCombinedType;
            }
        }
        return this.getGenericRelationshipType();
    }

    private Class getClassForCombinedType(String combinedType) {
        String[] parts = StringUtils.split((String)combinedType, (String)COMBINED_RELATIONSHIP_KEY_SEP);
        String sourceType = parts[0];
        String relType = parts[1];
        String targetType = parts[2];
        return this.getClassForCombinedType(sourceType, relType, targetType);
    }

    private Class getClassForCombinedType(String sourceType, String relType, String targetType) {
        return StructrApp.getConfiguration().getRelationClassForCombinedType(sourceType, relType, targetType);
    }

    private class LabelExtractor
    implements Function<Label, String> {
        private LabelExtractor() {
        }

        @Override
        public String apply(Label from) throws RuntimeException {
            return from.name();
        }
    }
}

