/*
 * Decompiled with CFR 0.152.
 */
package org.structr.common;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.structr.common.Permission;
import org.structr.core.property.PropertyKey;

public class PermissionResolutionMask {
    private static final Set<String> systemProperties = new HashSet<String>(Arrays.asList("id", "type"));
    private final Set<String> removedProperties = new HashSet<String>();
    private final int READ = 1;
    private final int WRITE = 2;
    private final int DELETE = 4;
    private final int ACCESS_CONTROL = 8;
    private int checked = 0;
    private int value = 0;

    public PermissionResolutionMask() {
    }

    public PermissionResolutionMask(PermissionResolutionMask toCopy) {
        this.removedProperties.addAll(toCopy.removedProperties);
        this.value = toCopy.value;
        this.checked = toCopy.checked;
    }

    public String toString() {
        return "mask: " + Integer.toBinaryString(this.value) + ", checked: " + Integer.toBinaryString(this.checked);
    }

    public boolean alreadyChecked(Permission permission) {
        if (Permission.read.equals(permission)) {
            return (this.checked & 1) != 0;
        }
        if (Permission.write.equals(permission)) {
            return (this.checked & 2) != 0;
        }
        if (Permission.delete.equals(permission)) {
            return (this.checked & 4) != 0;
        }
        if (Permission.accessControl.equals(permission)) {
            return (this.checked & 8) != 0;
        }
        return false;
    }

    public boolean setChecked(Permission permission) {
        if (Permission.read.equals(permission)) {
            this.checked |= 1;
        }
        if (Permission.write.equals(permission)) {
            this.checked |= 2;
        }
        if (Permission.delete.equals(permission)) {
            this.checked |= 4;
        }
        if (Permission.accessControl.equals(permission)) {
            this.checked |= 8;
        }
        return false;
    }

    public boolean setPermission(Permission permission, boolean isAllowed) {
        if (Permission.read.equals(permission)) {
            this.value = isAllowed ? (this.value |= 1) : (this.value &= 0xFFFFFFFE);
        }
        if (Permission.write.equals(permission)) {
            this.value = isAllowed ? (this.value |= 2) : (this.value &= 0xFFFFFFFD);
        }
        if (Permission.delete.equals(permission)) {
            this.value = isAllowed ? (this.value |= 4) : (this.value &= 0xFFFFFFFB);
        }
        if (Permission.accessControl.equals(permission)) {
            this.value = isAllowed ? (this.value |= 8) : (this.value &= 0xFFFFFFF7);
        }
        return false;
    }

    public boolean allowsPermission(Permission permission) {
        if (Permission.read.equals(permission)) {
            return (this.value & 1) != 0;
        }
        if (Permission.write.equals(permission)) {
            return (this.value & 2) != 0;
        }
        if (Permission.delete.equals(permission)) {
            return (this.value & 4) != 0;
        }
        if (Permission.accessControl.equals(permission)) {
            return (this.value & 8) != 0;
        }
        return false;
    }

    public void clear() {
        this.value = 0;
    }

    public boolean allowsProperty(PropertyKey key) {
        String name = key.jsonName();
        if (systemProperties.contains(name)) {
            return true;
        }
        return !this.removedProperties.contains(name);
    }

    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public Set<String> propertyMask() {
        return this.removedProperties;
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public void addRead() {
        this.value |= 1;
    }

    public void removeRead() {
        this.value &= 0xFFFFFFFE;
    }

    public void addWrite() {
        this.value |= 2;
    }

    public void removeWrite() {
        this.value &= 0xFFFFFFFD;
    }

    public void addDelete() {
        this.value |= 4;
    }

    public void removeDelete() {
        this.value &= 0xFFFFFFFB;
    }

    public void addAccessControl() {
        this.value |= 8;
    }

    public void removeAccessControl() {
        this.value &= 0xFFFFFFF7;
    }

    public void handleProperties(String delta) {
        if (delta != null) {
            for (String prop : delta.split("[, ]+")) {
                this.removedProperties.add(prop.substring(1).trim());
            }
        }
    }

    public PermissionResolutionMask copy() {
        return new PermissionResolutionMask(this);
    }

    public void restore(PermissionResolutionMask mask) {
        this.removedProperties.clear();
        this.removedProperties.addAll(mask.removedProperties);
        this.value = mask.value;
    }
}

